/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.operations;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.osee.ote.define.jobs.FindCommitableJob;
import org.eclipse.osee.ote.define.jobs.OutfileToArtifactJob;

public class ImportOutfileOperation {
    private final URI[] fileSystemObjects;
    private final BranchToken selectedBranch;

    public ImportOutfileOperation(BranchToken selectedBranch, URI ... fileSystemObjects) {
        this.checkForNull(selectedBranch);
        this.checkForNull(fileSystemObjects);
        this.checkForEmpty(fileSystemObjects);
        this.fileSystemObjects = fileSystemObjects;
        this.selectedBranch = selectedBranch;
    }

    private void checkSuccessful(IStatus status) {
        if (!status.equals(Status.OK_STATUS) && !status.equals(0)) {
            throw new OseeStateException("Error detected: %s", new Object[]{status.getMessage()});
        }
    }

    private void checkForEmpty(Object[] items) {
        if (items.length <= 0) {
            throw new OseeArgumentException("No items to process. Size was 0.", new Object[0]);
        }
    }

    private void checkForNull(Object object) {
        if (object == null) {
            throw new OseeArgumentException("Object cannot be null", new Object[0]);
        }
    }

    public void execute(IProgressMonitor monitor) throws Exception {
        OutfileToArtifactJob job = new OutfileToArtifactJob(this.selectedBranch, this.fileSystemObjects);
        job.setUser(false);
        job.schedule();
        job.join();
        this.checkSuccessful(job.getResult());
        Object[] itemsWithError = job.getUnparseableFiles();
        if (itemsWithError.length > 0) {
            throw new Exception(String.format("Error parsing files [%s]", Arrays.deepToString(itemsWithError)));
        }
        this.launchFindCommitableJob(monitor, "", job.getResults());
    }

    private void launchFindCommitableJob(IProgressMonitor monitor, String commitComment, Artifact[] artifacts) throws Exception {
        FindCommitableJob job = new FindCommitableJob(artifacts);
        job.setUser(false);
        job.schedule();
        job.join();
        this.checkSuccessful(job.getResult());
        Artifact[] notAllowed = job.getCommitNotAllowed();
        if (notAllowed.length > 0) {
            throw new OseeArgumentException("Some items are not commitable. [%s]", new Object[]{this.toString(notAllowed)});
        }
        this.commitSelectedArtifacts(monitor, commitComment, job.getCommitAllowed());
    }

    private String toString(Artifact[] artifacts) {
        return Collections.toString(Arrays.asList(artifacts), (String)",\n", Named::getName);
    }

    private void commitSelectedArtifacts(IProgressMonitor monitor, String commitComment, Object[] items) throws Exception {
        Map<BranchToken, List<Artifact>> commitMap = this.getArtifactsByBranch(items);
        for (BranchToken branch : commitMap.keySet()) {
            monitor.setTaskName(String.format("Committing Artifacts into Branch: [%s]", branch.getName()));
            List<Artifact> artList = commitMap.get(branch);
            ImportOutfileOperation.commitTestRunTx(monitor, commitComment, (BranchId)branch, artList.toArray(new Artifact[artList.size()]));
        }
    }

    private Map<BranchToken, List<Artifact>> getArtifactsByBranch(Object[] items) {
        HashMap<BranchToken, List<Artifact>> branchMap = new HashMap<BranchToken, List<Artifact>>();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Artifact testRun = (Artifact)object;
            BranchToken branch = testRun.getBranchToken();
            ArrayList<Artifact> artList = (ArrayList<Artifact>)branchMap.get(branch);
            if (artList == null) {
                artList = new ArrayList<Artifact>();
                branchMap.put(branch, artList);
            }
            artList.add(testRun);
            ++n2;
        }
        return branchMap;
    }

    public static void commitTestRunTx(IProgressMonitor monitor, String commitComment, BranchId branch, Artifact ... artifacts) {
        monitor.setTaskName("Persist Test Runs");
        Date uploadDate = new Date();
        Artifact[] artifactArray = artifacts;
        int n = artifacts.length;
        int n2 = 0;
        while (n2 < n) {
            Artifact artifact = artifactArray[n2];
            monitor.subTask(String.format("Persisting: [%s] ", artifact.getName()));
            ArtifactTestRunOperator operator = new ArtifactTestRunOperator(artifact);
            operator.setLastDateUploaded(uploadDate);
            if (monitor.isCanceled()) break;
            monitor.worked(1);
            ++n2;
        }
        TransactionManager.persistInTransaction((String)commitComment, (Artifact[])artifacts);
        if (monitor.isCanceled()) {
            throw new OseeCoreException("User Cancelled", new Object[0]);
        }
        monitor.done();
    }
}

