/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.topic.event.filter;

import java.util.List;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicRelationTransfer;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;

public class BranchIdTopicEventFilter
implements ITopicEventFilter {
    private final BranchId branchToken;

    public BranchIdTopicEventFilter(BranchId branchToken) {
        this.branchToken = branchToken;
    }

    @Override
    public boolean isMatch(BranchId branch) {
        if (this.branchToken != null) {
            return this.branchToken.equals(branch);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.branchToken.getId());
    }

    @Override
    public boolean isMatchArtifacts(List<? extends EventTopicArtifactTransfer> transferArts) {
        if (transferArts.isEmpty()) {
            return true;
        }
        for (EventTopicArtifactTransfer eventTopicArtifactTransfer : transferArts) {
            if (!eventTopicArtifactTransfer.getArtifactToken().isOnBranch(this.branchToken)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatchRelationArtifacts(List<? extends EventTopicRelationTransfer> transferRelations) {
        if (transferRelations.isEmpty()) {
            return true;
        }
        for (EventTopicRelationTransfer eventTopicRelationTransfer : transferRelations) {
            if (!eventTopicRelationTransfer.getArtAId().isOnBranch(this.branchToken) && !eventTopicRelationTransfer.getArtBId().isOnBranch(this.branchToken)) continue;
            return true;
        }
        return false;
    }
}

