/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event.handlers;

import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteTransactionEvent1;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionChange;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEvent;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEventType;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerRemote;
import org.eclipse.osee.framework.skynet.core.internal.event.Transport;

public class TransactionRemoteEventHandler
implements EventHandlerRemote<RemoteTransactionEvent1> {
    private final OrcsTokenService tokenService;

    public TransactionRemoteEventHandler(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    @Override
    public void handle(Transport transport, Sender sender, RemoteTransactionEvent1 remoteEvent) {
        TransactionEvent transEvent = FrameworkEventUtil.getTransactionEvent(remoteEvent, this.tokenService);
        if (transEvent.getEventType() == TransactionEventType.Purged) {
            TransactionRemoteEventHandler.handleRemotePurgeTransactionEvent(transEvent);
            transport.send(sender, transEvent);
        } else {
            EventUtil.eventLog((String)"REM: handleTransactionEvent - unhandled mod type [%s] ", (Object[])new Object[]{transEvent.getEventType()});
        }
    }

    public static void handleRemotePurgeTransactionEvent(TransactionEvent transEvent) {
        if (transEvent.getEventType() == TransactionEventType.Purged) {
            HashSet<Artifact> artifactsInCache = new HashSet<Artifact>();
            for (TransactionChange transChange : transEvent.getTransactionChanges()) {
                for (DefaultBasicGuidArtifact guidArt : transChange.getArtifacts()) {
                    try {
                        Artifact artifact = ArtifactCache.getActive(guidArt);
                        if (artifact == null) continue;
                        artifactsInCache.add(artifact);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
            if (!artifactsInCache.isEmpty()) {
                try {
                    ArtifactQuery.reloadArtifacts(artifactsInCache);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
    }
}

