/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.operations;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughArtifactCollector;
import org.eclipse.osee.framework.skynet.core.importing.parsers.IArtifactExtractor;

public class SourceToRoughArtifactOperation
extends AbstractOperation {
    private final OperationLogger logger;
    private final IArtifactExtractor extractor;
    private final File sourceFile;
    private final RoughArtifactCollector collector;

    public SourceToRoughArtifactOperation(OperationLogger logger, IArtifactExtractor extractor, File sourceFile, RoughArtifactCollector collector) {
        super("Extract artifact data from source", "org.eclipse.osee.framework.skynet.core");
        this.extractor = extractor;
        this.sourceFile = sourceFile;
        this.collector = collector;
        this.logger = logger;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        File[] files = new File[]{this.sourceFile};
        double workPercentage = 1.0 / (double)files.length;
        this.extractArtifacts(monitor, workPercentage, files, this.collector, this.collector.getParentRoughArtifact());
    }

    private void extractArtifacts(IProgressMonitor monitor, double workPercentage, File[] files, RoughArtifactCollector collector, RoughArtifact parentArtifact) {
        int workAmount = this.calculateWork(workPercentage);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                this.processFile(file, collector, parentArtifact);
            } else if (file.isDirectory()) {
                RoughArtifact directoryArtifact = new RoughArtifact(CoreArtifactTypes.Folder, file.getName());
                collector.addChildRoughArtifact(directoryArtifact);
                File[] subFiles = file.listFiles(this.extractor.getFileFilter());
                if (files.length > 0) {
                    double subPercentage = workPercentage / (double)subFiles.length;
                    this.extractArtifacts(monitor, subPercentage, subFiles, collector, directoryArtifact);
                }
            } else {
                throw new OseeStateException("Source location [%s] is not a valid file or directory", new Object[]{file});
            }
            if (monitor != null) {
                monitor.worked(workAmount);
            }
            ++n2;
        }
    }

    private void processFile(File file, RoughArtifactCollector collector, RoughArtifact parent) {
        RoughArtifactCollector tempCollector = new RoughArtifactCollector(parent);
        try {
            this.extractor.process(this.logger, file.toURI(), tempCollector);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        collector.addAllRoughArtifacts(tempCollector.getRoughArtifacts());
        collector.addAllRoughRelations(tempCollector.getRoughRelations());
    }
}

