/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.RoughRelation;

public class RoughArtifactCollector {
    private final List<RoughArtifact> roughArtifacts;
    private final List<RoughRelation> roughRelations;
    private final RoughArtifact parentRoughArtifact;

    public RoughArtifactCollector(RoughArtifact parentRoughArtifact) {
        this.parentRoughArtifact = parentRoughArtifact;
        this.roughArtifacts = new ArrayList<RoughArtifact>();
        this.roughRelations = new ArrayList<RoughRelation>();
    }

    public void reset() {
        if (this.parentRoughArtifact != null) {
            this.parentRoughArtifact.clear();
        }
        this.roughArtifacts.clear();
        this.roughRelations.clear();
    }

    public void addRoughArtifact(RoughArtifact roughArtifact) {
        this.roughArtifacts.add(roughArtifact);
    }

    public void addChildRoughArtifact(RoughArtifact roughArtifact) {
        this.parentRoughArtifact.addChild(roughArtifact);
        this.addRoughArtifact(roughArtifact);
    }

    public void addRoughRelation(RoughRelation roughRelation) {
        this.roughRelations.add(roughRelation);
    }

    public RoughArtifact getParentRoughArtifact() {
        return this.parentRoughArtifact;
    }

    public void addAllRoughArtifacts(Collection<RoughArtifact> roughArtifact) {
        this.roughArtifacts.addAll(roughArtifact);
    }

    public void addAllRoughRelations(Collection<RoughRelation> roughRelation) {
        this.roughRelations.addAll(roughRelation);
    }

    public List<RoughArtifact> getRoughArtifacts() {
        return this.roughArtifacts;
    }

    public List<RoughRelation> getRoughRelations() {
        return this.roughRelations;
    }

    public boolean removeArtifact(RoughArtifact roughArtifact) {
        return this.roughArtifacts.remove(roughArtifact);
    }

    public String toString() {
        return this.roughArtifacts.toString();
    }
}

