/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.osee.framework.plugin.core.util.ExtensionDefinedObjects;
import org.eclipse.osee.framework.skynet.core.importing.parsers.IArtifactExtractor;
import org.eclipse.osee.framework.skynet.core.importing.parsers.IArtifactExtractorDelegate;

public class ArtifactExtractorContributionManager {
    private static final String PARSER_ELEMENT = "ArtifactExtractor";
    private static final String PARSER_DELEGATE_ELEMENT = "ArtifactExtractorDelegate";
    private static final String PARSER_EXTENSION = "org.eclipse.osee.framework.skynet.core.ArtifactExtractor";
    private static final String PARSER_DELEGATE_EXTENSION = "org.eclipse.osee.framework.skynet.core.ArtifactExtractorDelegate";
    private static final String CLASS_NAME_ATTRIBUTE = "classname";

    public List<IArtifactExtractor> getExtractors() {
        ExtensionDefinedObjects definedObjects = new ExtensionDefinedObjects(PARSER_EXTENSION, PARSER_ELEMENT, CLASS_NAME_ATTRIBUTE, true);
        List items = definedObjects.getObjects();
        Collections.sort(items, new ParserComparator());
        return items;
    }

    public List<IArtifactExtractorDelegate> getAllDelegates() {
        ArrayList<IArtifactExtractorDelegate> contentHandlers = new ArrayList<IArtifactExtractorDelegate>();
        ExtensionDefinedObjects contributions = new ExtensionDefinedObjects(PARSER_DELEGATE_EXTENSION, PARSER_DELEGATE_ELEMENT, CLASS_NAME_ATTRIBUTE, true);
        for (IArtifactExtractorDelegate delegate : contributions.getObjects()) {
            contentHandlers.add(delegate);
        }
        return contentHandlers;
    }

    public List<IArtifactExtractorDelegate> getDelegates(IArtifactExtractor parser) {
        ArrayList<IArtifactExtractorDelegate> contentHandlers = new ArrayList<IArtifactExtractorDelegate>();
        if (parser != null) {
            for (IArtifactExtractorDelegate delegate : this.getAllDelegates()) {
                if (!delegate.isApplicable(parser)) continue;
                contentHandlers.add(delegate);
            }
            Collections.sort(contentHandlers, new ParserDelegateComparator());
        }
        return contentHandlers;
    }

    private static final class ParserComparator
    implements Comparator<IArtifactExtractor>,
    Serializable {
        private static final long serialVersionUID = 297281600323509207L;

        private ParserComparator() {
        }

        @Override
        public int compare(IArtifactExtractor o1, IArtifactExtractor o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    private static final class ParserDelegateComparator
    implements Comparator<IArtifactExtractorDelegate>,
    Serializable {
        private static final long serialVersionUID = 803641362587689953L;

        private ParserDelegateComparator() {
        }

        @Override
        public int compare(IArtifactExtractorDelegate o1, IArtifactExtractorDelegate o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

