/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Arrays;
import java.util.function.Supplier;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class DecorationOverlayIcon
extends CompositeImageDescriptor {
    private Object referenceImageOrDescriptor;
    private ImageDescriptor[] overlays;
    private ImageDataProvider baseImageDataProvider;
    private Supplier<Point> size;

    public DecorationOverlayIcon(Image baseImage, ImageDescriptor[] overlaysArray, Point sizeValue) {
        this.referenceImageOrDescriptor = baseImage;
        this.overlays = overlaysArray;
        this.baseImageDataProvider = this.createCachedImageDataProvider(baseImage);
        this.size = () -> sizeValue;
    }

    public DecorationOverlayIcon(Image baseImage, ImageDescriptor[] overlaysArray) {
        this(baseImage, overlaysArray, new Point(baseImage.getBounds().width, baseImage.getBounds().height));
    }

    public DecorationOverlayIcon(Image baseImage, ImageDescriptor overlayImage, int quadrant) {
        this(baseImage, DecorationOverlayIcon.createArrayFrom(overlayImage, quadrant));
    }

    public DecorationOverlayIcon(ImageDescriptor baseImageDescriptor, ImageDescriptor overlayImageDescriptor, int quadrant) {
        this.referenceImageOrDescriptor = baseImageDescriptor;
        this.overlays = DecorationOverlayIcon.createArrayFrom(overlayImageDescriptor, quadrant);
        this.baseImageDataProvider = this.createCachedImageDataProvider(baseImageDescriptor);
        this.size = () -> {
            ImageData data;
            int zoomLevel = this.getZoomLevel();
            if (zoomLevel != 0 && (data = this.baseImageDataProvider.getImageData(zoomLevel)) != null) {
                return new Point(this.autoScaleDown(data.width), this.autoScaleDown(data.height));
            }
            data = this.baseImageDataProvider.getImageData(100);
            return new Point(data.width, data.height);
        };
    }

    private static ImageDescriptor[] createArrayFrom(ImageDescriptor overlayImage, int quadrant) {
        ImageDescriptor[] descs = new ImageDescriptor[5];
        descs[quadrant] = overlayImage;
        return descs;
    }

    private void drawOverlays(ImageDescriptor[] overlaysArray) {
        int i = 0;
        while (i < this.overlays.length) {
            ImageDescriptor overlay = overlaysArray[i];
            if (overlay != null) {
                CompositeImageDescriptor.CachedImageDataProvider overlayImageProvider = this.createCachedImageDataProvider(overlay);
                switch (i) {
                    case 0: {
                        this.drawImage(overlayImageProvider, 0, 0);
                        break;
                    }
                    case 1: {
                        int overlayWidth = overlayImageProvider.getWidth();
                        this.drawImage(overlayImageProvider, this.getSize().x - overlayWidth, 0);
                        break;
                    }
                    case 2: {
                        int overlayHeight = overlayImageProvider.getHeight();
                        this.drawImage(overlayImageProvider, 0, this.getSize().y - overlayHeight);
                        break;
                    }
                    case 3: {
                        int overlayWidth = overlayImageProvider.getWidth();
                        int overlayHeight = overlayImageProvider.getHeight();
                        this.drawImage(overlayImageProvider, this.getSize().x - overlayWidth, this.getSize().y - overlayHeight);
                    }
                }
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DecorationOverlayIcon)) {
            return false;
        }
        DecorationOverlayIcon other = (DecorationOverlayIcon)o;
        return this.referenceImageOrDescriptor.equals(other.referenceImageOrDescriptor) && Arrays.equals(this.overlays, other.overlays);
    }

    public int hashCode() {
        int code = System.identityHashCode(this.referenceImageOrDescriptor);
        ImageDescriptor[] imageDescriptorArray = this.overlays;
        int n = this.overlays.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor overlay = imageDescriptorArray[n2];
            if (overlay != null) {
                code ^= overlay.hashCode();
            }
            ++n2;
        }
        return code;
    }

    @Override
    protected void drawCompositeImage(int width, int height) {
        ImageDescriptor underlay;
        if (this.overlays.length > 4 && (underlay = this.overlays[4]) != null) {
            this.drawImage(this.createCachedImageDataProvider(underlay), 0, 0);
        }
        if (this.overlays.length > 5 && this.overlays[5] != null) {
            this.drawImage(this.createCachedImageDataProvider(this.overlays[5]), 0, 0);
        } else {
            this.drawImage(this.baseImageDataProvider, 0, 0);
        }
        this.drawOverlays(this.overlays);
    }

    @Override
    protected Point getSize() {
        return this.size.get();
    }

    @Override
    protected int getTransparentPixel() {
        return this.baseImageDataProvider.getImageData((int)100).transparentPixel;
    }
}

