/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.osee.define.ide.traceability.ArtifactOperations;
import org.eclipse.osee.define.ide.traceability.RequirementTraceabilityData;
import org.eclipse.osee.define.ide.traceability.report.ISimpleTable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class StdTestToCsciTable
implements ISimpleTable {
    private final RequirementTraceabilityData source;
    boolean onePerRow = false;

    public StdTestToCsciTable(RequirementTraceabilityData source, boolean onePerRow) {
        this.source = source;
        this.onePerRow = onePerRow;
    }

    @Override
    public String getHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"32.25\"/>");
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"169.5\"/>");
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"82.5\"/>");
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"275.25\"/>");
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"169.5\"/>");
        builder.append("<Row ss:Height=\"13.5\">");
        builder.append("<Cell ss:MergeAcross=\"4\" ss:StyleID=\"s21\"><Data ss:Type=\"String\">Table X.X: Test to CSCI Requirements Traceability</Data></Cell>");
        builder.append("</Row>");
        builder.append("<Row ss:Height=\"14.25\">");
        builder.append("<Cell ss:MergeDown=\"1\" ss:StyleID=\"m15149990\"><Data ss:Type=\"String\">Test</Data></Cell>");
        builder.append("<Cell ss:MergeDown=\"1\" ss:StyleID=\"m15150000\"><Data ss:Type=\"String\">Test Script / Test Procedure</Data></Cell>");
        builder.append("<Cell ss:MergeAcross=\"2\" ss:StyleID=\"m15150010\"><Data ss:Type=\"String\">CSCI Requirement</Data></Cell>");
        builder.append("</Row>");
        builder.append("<Row ss:Height=\"14.25\">");
        builder.append("<Cell ss:Index=\"3\" ss:StyleID=\"s28\"><Data ss:Type=\"String\">Paragraph #</Data></Cell>");
        builder.append("<Cell ss:StyleID=\"s28\"><Data ss:Type=\"String\">Paragraph Title</Data></Cell>");
        builder.append("<Cell ss:StyleID=\"s28\"><Data ss:Type=\"String\">Requirement Type</Data></Cell>");
        builder.append("</Row>");
        return builder.toString();
    }

    @Override
    public String getHeaderStyles() {
        StringBuilder builder = new StringBuilder();
        builder.append("<Styles><Style ss:ID=\"Default\" ss:Name=\"Normal\">");
        builder.append("<Alignment ss:Vertical=\"Bottom\"/>");
        builder.append("<Borders/><Font/><Interior/><NumberFormat/><Protection/></Style>");
        builder.append("<Style ss:ID=\"m15149990\"><Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\"/><Borders>");
        builder.append("<Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Left\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Right\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Top\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("</Borders><Font x:Family=\"Swiss\" ss:Bold=\"1\"/></Style><Style ss:ID=\"m15150000\">");
        builder.append("<Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\" ss:WrapText=\"1\"/><Borders>");
        builder.append("<Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Left\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Right\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Top\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("</Borders><Font x:Family=\"Swiss\" ss:Bold=\"1\"/></Style><Style ss:ID=\"m15150010\">");
        builder.append("<Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\"/><Borders>");
        builder.append("<Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Left\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Right\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Top\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("</Borders><Font x:Family=\"Swiss\" ss:Bold=\"1\"/></Style><Style ss:ID=\"s21\">");
        builder.append("<Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\"/><Borders>");
        builder.append("<Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("</Borders><Font x:Family=\"Swiss\" ss:Bold=\"1\"/></Style><Style ss:ID=\"s28\">");
        builder.append("<Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\"/><Borders>");
        builder.append("<Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Left\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Right\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Top\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("</Borders><Font x:Family=\"Swiss\" ss:Bold=\"1\"/>");
        builder.append("</Style>");
        builder.append("<Style ss:ID=\"s38\"><Alignment ss:Vertical=\"Bottom\" ss:WrapText=\"1\"/></Style>");
        builder.append("</Styles>");
        return builder.toString();
    }

    @Override
    public String getWorksheetName() {
        return "STD - Test to CSCI Requirements Traceability";
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public void generateBody(ExcelXmlWriter sheetWriter) throws Exception {
        Collection<Artifact> directRequirements = this.source.getAllSwRequirements();
        HashCollectionSet<String, Artifact> partitionMap = ArtifactOperations.sortByPartition(directRequirements);
        HashCollection<Artifact, String> requirementsToQualificationMethod = this.getQualificationMethods(this.source);
        HashCollectionSet partitionToQualificationMethod = new HashCollectionSet(TreeSet::new);
        HashCollectionSet qualificationMethodToRequirements = new HashCollectionSet(TreeSet::new);
        for (String partition : partitionMap.keySet()) {
            for (Artifact artifact : (Set)partitionMap.getValues((Object)partition)) {
                Collection values = requirementsToQualificationMethod.getValues((Object)artifact);
                if (values == null) continue;
                for (String codeUnit : values) {
                    if (Strings.isValid((String)codeUnit)) {
                        int index = codeUnit.lastIndexOf(File.separator);
                        codeUnit = codeUnit.substring(index + 1, codeUnit.length());
                    }
                    partitionToQualificationMethod.put((Object)partition, (Object)codeUnit);
                    qualificationMethodToRequirements.put((Object)codeUnit, (Object)artifact);
                }
            }
        }
        for (String partition : new TreeSet(partitionToQualificationMethod.keySet())) {
            ArrayList units = new ArrayList(partitionToQualificationMethod.getValues((Object)partition));
            Collections.sort(units);
            for (String codeUnit : units) {
                HashSet<Artifact> artifacts = new HashSet<Artifact>();
                for (Artifact req : (Set)qualificationMethodToRequirements.getValues((Object)codeUnit)) {
                    List attributeValues = req.getAttributeValues((AttributeTypeId)CoreAttributeTypes.Partition);
                    if (!attributeValues.contains(partition)) continue;
                    artifacts.add(req);
                }
                if (this.onePerRow) {
                    this.processSingleRow((ISheetWriter)sheetWriter, partition, codeUnit, ArtifactOperations.sortByParagraphNumbers(artifacts));
                    continue;
                }
                this.processRow((ISheetWriter)sheetWriter, partition, codeUnit, ArtifactOperations.sortByParagraphNumbers(artifacts));
            }
        }
    }

    private HashCollection<Artifact, String> getQualificationMethods(RequirementTraceabilityData source) {
        HashCollection toReturn = new HashCollection();
        HashCollectionSet<Artifact, String> requirementsToCodeUnits = source.getRequirementsToCodeUnits();
        for (Artifact requirement : source.getAllSwRequirements()) {
            ArrayList testScripts = new ArrayList();
            requirementsToCodeUnits.forEachValue((Object)requirement, testScripts::add);
            toReturn.put((Object)requirement, testScripts);
        }
        return toReturn;
    }

    private void processRow(ISheetWriter sheetWriter, String partition, String codeUnit, Collection<Artifact> artifacts) throws Exception {
        ArrayList<String> paragraphTitles = new ArrayList<String>();
        ArrayList<String> paragraphNumbers = new ArrayList<String>();
        ArrayList<String> artifactTypes = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            ArtifactOperations operator = new ArtifactOperations(artifact);
            String name = operator.getName();
            String number = operator.getParagraphNumber();
            if (paragraphTitles.contains(name) || paragraphNumbers.contains(number)) continue;
            paragraphTitles.add(name);
            artifactTypes.add(artifact.getArtifactTypeName());
            if (!Strings.isValid((String)number)) {
                number = "-1";
            }
            paragraphNumbers.add(number);
        }
        String paragraphTitle = org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",\n", paragraphTitles);
        String paragraphNumber = org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",\n", paragraphNumbers);
        String artifactType = org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",\n", artifactTypes);
        sheetWriter.writeRow(new Object[]{partition, codeUnit, paragraphNumber, paragraphTitle, artifactType});
    }

    private void processSingleRow(ISheetWriter sheetWriter, String partition, String codeUnit, Collection<Artifact> artifacts) throws Exception {
        for (Artifact artifact : artifacts) {
            ArtifactOperations operator = new ArtifactOperations(artifact);
            String name = operator.getName();
            String number = operator.getParagraphNumber();
            sheetWriter.writeRow(new Object[]{partition, codeUnit, number, name, artifact.getArtifactTypeName()});
        }
    }
}

