/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.DataRightsClassification;
import org.eclipse.osee.framework.core.model.type.LinkType;
import org.eclipse.osee.framework.core.util.RendererOption;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer;
import org.eclipse.osee.framework.ui.skynet.templates.TemplateManager;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PublishWithSpecifiedTemplate
extends AbstractBlam {
    private static String ARTIFACTS = "Artifacts";
    private static String PARENT_TEMPLATE = "Parent Template";
    private static String CHILD_TEMPLATE = "Child Template";
    private static String DATA_RIGHTS = "Data Rights";
    private List<Artifact> templates;
    private BranchId branch;
    private Map<Long, String> branchViews;
    private XBranchSelectWidget branchWidget;
    private XCombo childWidget;
    private XCombo branchViewWidget;
    private XListDropViewer artifactsWidget;
    private XCombo dataRightsWidget;

    public String getName() {
        return "Publish With Specified Template";
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        this.populateTemplateList();
        boolean useArtifactNameInLinks = variableMap.getBoolean(RendererOption.USE_ARTIFACT_NAMES.getKey());
        boolean useParagraphNumbersInLinks = variableMap.getBoolean(RendererOption.USE_PARAGRAPH_NUMBERS.getKey());
        if (!useParagraphNumbersInLinks && !useArtifactNameInLinks) {
            throw new OseeArgumentException("Please select at least one Document Link Format", new Object[0]);
        }
        LinkType linkType = useArtifactNameInLinks && useParagraphNumbersInLinks ? LinkType.INTERNAL_DOC_REFERENCE_USE_PARAGRAPH_NUMBER_AND_NAME : (useParagraphNumbersInLinks ? LinkType.INTERNAL_DOC_REFERENCE_USE_PARAGRAPH_NUMBER : LinkType.INTERNAL_DOC_REFERENCE_USE_NAME);
        Artifact parent = this.getTemplate(variableMap.getString(PARENT_TEMPLATE));
        if (parent == null) {
            throw new OseeArgumentException("Must select a Parent Template", new Object[0]);
        }
        Artifact child = this.getTemplate(variableMap.getString(CHILD_TEMPLATE));
        String classification = variableMap.getString(DATA_RIGHTS);
        List artifacts = variableMap.getArtifacts(ARTIFACTS);
        if (artifacts == null || artifacts.isEmpty()) {
            throw new OseeArgumentException("Must provide an artifact", new Object[0]);
        }
        this.branch = ((Artifact)artifacts.get(0)).getBranch();
        if (this.branch == null) {
            throw new OseeArgumentException("Cannot determine IS branch.", new Object[0]);
        }
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)this.branch, (String)"BLAM: Publish with specified template");
        Object view = variableMap.getValue(RendererOption.VIEW.getKey());
        ArtifactId viewId = ArtifactId.SENTINEL;
        if (this.branchViews != null && !this.branchViews.isEmpty()) {
            for (Map.Entry<Long, String> entry : this.branchViews.entrySet()) {
                if (!entry.getValue().equals(view)) continue;
                viewId = ArtifactId.valueOf((Long)entry.getKey());
            }
        }
        HashMap<RendererOption, Object> rendererOptionsMap = new HashMap<RendererOption, Object>();
        rendererOptionsMap.put(RendererOption.BRANCH, this.branch);
        rendererOptionsMap.put(RendererOption.COMPARE_BRANCH, variableMap.getValue(RendererOption.WAS_BRANCH.getKey()));
        rendererOptionsMap.put(RendererOption.INCLUDE_UUIDS, variableMap.getValue(RendererOption.INCLUDE_UUIDS.getKey()));
        rendererOptionsMap.put(RendererOption.LINK_TYPE, linkType);
        rendererOptionsMap.put(RendererOption.UPDATE_PARAGRAPH_NUMBERS, variableMap.getBoolean(RendererOption.UPDATE_PARAGRAPH_NUMBERS.getKey()));
        rendererOptionsMap.put(RendererOption.EXCLUDE_ARTIFACT_TYPES, variableMap.getArtifactTypes(RendererOption.EXCLUDE_ARTIFACT_TYPES.getKey()));
        rendererOptionsMap.put(RendererOption.TRANSACTION_OPTION, transaction);
        rendererOptionsMap.put(RendererOption.SKIP_ERRORS, true);
        rendererOptionsMap.put(RendererOption.EXCLUDE_FOLDERS, true);
        rendererOptionsMap.put(RendererOption.RECURSE, true);
        rendererOptionsMap.put(RendererOption.MAINTAIN_ORDER, true);
        rendererOptionsMap.put(RendererOption.PROGRESS_MONITOR, monitor);
        rendererOptionsMap.put(RendererOption.USE_TEMPLATE_ONCE, true);
        rendererOptionsMap.put(RendererOption.FIRST_TIME, true);
        rendererOptionsMap.put(RendererOption.PUBLISH_DIFF, variableMap.getValue(RendererOption.PUBLISH_DIFF.getKey()));
        rendererOptionsMap.put(RendererOption.VIEW, viewId);
        rendererOptionsMap.put(RendererOption.PUBLISH_EMPTY_HEADERS, false);
        rendererOptionsMap.put(RendererOption.OVERRIDE_DATA_RIGHTS, classification);
        WordTemplateRenderer renderer = new WordTemplateRenderer(rendererOptionsMap);
        final Boolean isDiff = (Boolean)rendererOptionsMap.get(RendererOption.PUBLISH_DIFF);
        final AtomicInteger toProcessSize = new AtomicInteger(0);
        if (isDiff.booleanValue()) {
            for (Artifact art : artifacts) {
                toProcessSize.addAndGet(art.getDescendants().size());
            }
        }
        final AtomicReference result = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                double secPerArt = 2.0;
                double minutes = (double)toProcessSize.get() * secPerArt / 60.0;
                if (isDiff.booleanValue() && toProcessSize.get() > 900 && !MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Continue with Word Diff", (String)("You have chosen to do a word diff on " + toProcessSize.get() + " Artifacts.\n\n" + "This could be a very long running task (approximately " + minutes + "min) and consume large resources.\n\nAre you sure?"))) {
                    result.set(false);
                } else {
                    result.set(true);
                }
            }
        });
        if (((Boolean)result.get()).booleanValue()) {
            renderer.publish(parent, child, artifacts);
            transaction.execute();
            monitor.done();
        }
    }

    public String getDescriptionUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("<form>Use a template to publish a document or diff the document against a different version.<br/>");
        sb.append("Select Parameters<br/>");
        sb.append("<li>Select Update Paragraph Numbers if authorized to update them</li>");
        sb.append("<li>Choose whether or not you want the UUIDs published</li>");
        sb.append("<li>Select the Document Link format(s)</li>");
        sb.append("<li>Choose artifact type(s) to exclude</li>");
        sb.append("<li>Select Parent or Parent/Child (for SRS) template.  Only use non-recursive templates</li>");
        sb.append("<li>Drag &amp; Drop the IS Artifacts into the box OR write an Orcs Query that returns a list of Artifact Ids</li>");
        sb.append("<li>Decide to Publish as Diff and select WAS branch as desired</li>");
        sb.append("<br/>Click the play button at the top right or in the Execute section.</form>");
        return sb.toString();
    }

    public String getXWidgetsXml() {
        this.populateTemplateList();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("<xWidgets><XWidget xwidgetType=\"XCheckBox\" horizontalLabel=\"true\" labelAfter=\"true\" displayName=\"%s\" />", RendererOption.UPDATE_PARAGRAPH_NUMBERS.getKey()));
        builder.append(String.format("<XWidget xwidgetType=\"XCheckBox\" horizontalLabel=\"true\" labelAfter=\"true\" displayName=\"%s\" />", RendererOption.INCLUDE_UUIDS.getKey()));
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Document Link Format:\"/>");
        builder.append(String.format("<XWidget xwidgetType=\"XCheckBox\" horizontalLabel=\"true\" labelAfter=\"true\" displayName=\"%s\" defaultValue=\"true\"/>", RendererOption.USE_ARTIFACT_NAMES.getKey()));
        builder.append(String.format("<XWidget xwidgetType=\"XCheckBox\" horizontalLabel=\"true\" labelAfter=\"true\" displayName=\"%s\" />", RendererOption.USE_PARAGRAPH_NUMBERS.getKey()));
        builder.append(String.format("<XWidget xwidgetType=\"XArtifactTypeMultiChoiceSelect\" displayName=\"%s\" />", RendererOption.EXCLUDE_ARTIFACT_TYPES.getKey()));
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\" \" /><XWidget xwidgetType=\"XCombo(");
        for (Artifact art : this.templates) {
            builder.append(art.getSafeName());
            builder.append(",");
        }
        builder.append(String.format(")\" displayName=\"%s\" horizontalLabel=\"true\"/>", PARENT_TEMPLATE));
        builder.append("<XWidget xwidgetType=\"XCombo(");
        for (Artifact art : this.templates) {
            builder.append(art.getSafeName());
            builder.append(",");
        }
        builder.append(String.format(")\" displayName=\"%s\" horizontalLabel=\"true\"/><XWidget xwidgetType=\"XLabel\" displayName=\" \" />", CHILD_TEMPLATE));
        builder.append(String.format("<XWidget xwidgetType=\"XListDropViewer\" displayName=\"%s\" />", ARTIFACTS));
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\" \" /><XWidget xwidgetType=\"XCombo(");
        builder.append(String.format(")\" displayName=\"%s\" horizontalLabel=\"true\"/>", RendererOption.VIEW.getKey()));
        builder.append(String.format("<XWidget xwidgetType=\"XCheckBox\" horizontalLabel=\"true\" labelAfter=\"true\" displayName=\"%s\" />", RendererOption.OVERRIDE_DATA_RIGHTS.getKey()));
        builder.append("<XWidget xwidgetType=\"XCombo(");
        DataRightsClassification[] dataRightsClassificationArray = DataRightsClassification.values();
        int n = dataRightsClassificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataRightsClassification classification = dataRightsClassificationArray[n2];
            builder.append(classification.getDataRightsClassification());
            builder.append(",");
            ++n2;
        }
        builder.append(String.format(")\" displayName=\"%s\" horizontalLabel=\"true\"/>", DATA_RIGHTS));
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Generate Differences:\"/>");
        builder.append(String.format("<XWidget xwidgetType=\"XCheckBox\" horizontalLabel=\"true\" labelAfter=\"true\" displayName=\"%s\" />", RendererOption.PUBLISH_DIFF.getKey()));
        builder.append(String.format("<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"%s\"/>", RendererOption.WAS_BRANCH.getKey()));
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Note: If a WAS branch is selected, diffs will be between selected IS artifacts and current version on WAS branch\"/>");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"If a WAS branch is NOT selected, diffs will be between selected IS artifacts and baseline version on IS branch\"/>");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(RendererOption.WAS_BRANCH.getKey())) {
            this.branchWidget = (XBranchSelectWidget)xWidget;
            this.branchWidget.setEditable(false);
        } else if (xWidget.getLabel().equals(RendererOption.PUBLISH_DIFF.getKey())) {
            final XCheckBox checkBox = (XCheckBox)xWidget;
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    PublishWithSpecifiedTemplate.this.branchWidget.setEditable(checkBox.isChecked());
                    if (!checkBox.isChecked()) {
                        PublishWithSpecifiedTemplate.this.branchWidget.setSelection(null);
                    }
                }
            });
        } else if (xWidget.getLabel().equals(PARENT_TEMPLATE)) {
            final XCombo parentCombo = (XCombo)xWidget;
            parentCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String parentTemplate = parentCombo.get();
                    if (parentTemplate.contains("srsMaster") || parentTemplate.contains("ewsMaster") || parentTemplate.contains("srsParent") || parentTemplate.contains("ewsParent")) {
                        PublishWithSpecifiedTemplate.this.childWidget.setEnabled(true);
                        PublishWithSpecifiedTemplate.this.artifactsWidget.setEditable(false);
                    } else {
                        PublishWithSpecifiedTemplate.this.childWidget.setEnabled(false);
                        PublishWithSpecifiedTemplate.this.childWidget.set("");
                        PublishWithSpecifiedTemplate.this.artifactsWidget.setEditable(true);
                    }
                }
            });
        } else if (xWidget.getLabel().equals(CHILD_TEMPLATE)) {
            this.childWidget = (XCombo)xWidget;
            this.childWidget.setEnabled(false);
        } else if (xWidget.getLabel().equals(ARTIFACTS)) {
            this.artifactsWidget = (XListDropViewer)xWidget;
            this.artifactsWidget.setEditable(true);
            this.artifactsWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (PublishWithSpecifiedTemplate.this.branchViewWidget != null) {
                        Artifact art;
                        BranchToken isArtBranch;
                        PublishWithSpecifiedTemplate.this.branchViewWidget.setEditable(true);
                        List artifacts = PublishWithSpecifiedTemplate.this.artifactsWidget.getArtifacts();
                        if (artifacts != null && !artifacts.isEmpty() && (isArtBranch = (art = (Artifact)artifacts.iterator().next()).getBranch()) != null && isArtBranch.isValid() && ViewApplicabilityUtil.isBranchOfProductLine((BranchId)isArtBranch)) {
                            PublishWithSpecifiedTemplate.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)isArtBranch);
                            PublishWithSpecifiedTemplate.this.branchViewWidget.setDataStrings(PublishWithSpecifiedTemplate.this.branchViews.values());
                        }
                    }
                }
            });
        } else if (xWidget.getLabel().equals(RendererOption.VIEW.getKey())) {
            this.branchViewWidget = (XCombo)xWidget;
            this.branchViewWidget.setEditable(false);
        } else if (xWidget.getLabel().equals(RendererOption.OVERRIDE_DATA_RIGHTS.getKey())) {
            final XCheckBox overrideCheck = (XCheckBox)xWidget;
            overrideCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    if (overrideCheck.isChecked()) {
                        boolean override = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Override Data Rights", (String)"Delivering documents with the wrong data rights cannot be undone once submitted.\nAre you sure you want to override the data rights for this document?");
                        if (override) {
                            PublishWithSpecifiedTemplate.this.dataRightsWidget.setEnabled(true);
                        } else {
                            overrideCheck.set(false);
                        }
                    } else {
                        PublishWithSpecifiedTemplate.this.dataRightsWidget.setEnabled(false);
                        PublishWithSpecifiedTemplate.this.dataRightsWidget.set(0);
                    }
                }
            });
        } else if (xWidget.getLabel().equals(DATA_RIGHTS)) {
            this.dataRightsWidget = (XCombo)xWidget;
            this.dataRightsWidget.setEnabled(false);
        }
    }

    private void populateTemplateList() {
        this.templates = TemplateManager.getAllTemplates();
        Collections.sort(this.templates);
    }

    private Artifact getTemplate(String templateName) {
        for (Artifact artifact : this.templates) {
            if (!artifact.getSafeName().equals(templateName)) continue;
            return artifact;
        }
        return null;
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE);
    }
}

