/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.views;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.IPropertyStore;
import org.eclipse.osee.framework.ui.plugin.widgets.IPropertyStoreBasedControl;
import org.eclipse.osee.ote.ui.define.panels.GrayableBranchSelectionComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TestRunArtifactOptions
implements IPropertyStoreBasedControl {
    private GrayableBranchSelectionComposite panel;

    public Control createControl(Composite parent) {
        this.panel = new GrayableBranchSelectionComposite(parent, 0);
        this.panel.setFeatureEnabled(true);
        return this.panel;
    }

    public void load(IPropertyStore propertyStore) {
        boolean widgetEnabled = propertyStore.getBoolean("test.run.upload.enabled");
        String lastBranchSelected = propertyStore.get("last.branch.id");
        String[] branchUuids = propertyStore.getArray("all.branches.id");
        this.panel.restoreWidgetValues(widgetEnabled, branchUuids, lastBranchSelected);
    }

    public void save(IPropertyStore propertyStore) {
        propertyStore.put("test.run.upload.enabled", this.panel.isBranchSelectEnabled());
        propertyStore.put("all.branches.id", this.panel.getBranchIds());
        BranchId branch = this.panel.getSelectedBranch();
        propertyStore.put("last.branch.id", branch.getId().longValue());
    }

    public boolean areSettingsValid() {
        boolean result = true;
        if (this.panel.isBranchSelectEnabled()) {
            result &= this.panel.getSelectedBranch().isValid();
        }
        return result;
    }

    public String getErrorMessage() {
        StringBuilder builder = new StringBuilder();
        if (!this.areSettingsValid()) {
            builder.append("Artifact Upload: Please select a branch to upload test runs into.");
        }
        return builder.toString();
    }

    public int getPriority() {
        return 2;
    }
}

