/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.reports.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.util.TableWriterAdaptor;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.reports.output.IReportWriter;

public class ReportWriter
implements IReportWriter {
    private TableWriterAdaptor tableWriterAdapter;
    private ByteArrayOutputStream outputStream;

    public ReportWriter(String writerId) {
        try {
            this.outputStream = new ByteArrayOutputStream();
            this.tableWriterAdapter = new TableWriterAdaptor(writerId, (OutputStream)this.outputStream);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    @Override
    public String getReport() throws IOException {
        return this.outputStream.toString("ISO-8859-1");
    }

    @Override
    public int length() throws Exception {
        if (!this.tableWriterAdapter.isCompleted()) {
            try {
                this.tableWriterAdapter.openDocument();
                this.tableWriterAdapter.writeDocument();
            }
            finally {
                this.tableWriterAdapter.close();
            }
        }
        return this.outputStream.toByteArray().length;
    }

    @Override
    public void writeHeader(String[] headers) {
        try {
            this.tableWriterAdapter.writeHeader(headers);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    @Override
    public void writeRow(String ... cellData) {
        this.tableWriterAdapter.writeRow(cellData);
    }

    @Override
    public void writeTitle(String title) {
        this.tableWriterAdapter.writeTitle(title);
    }

    @Override
    public void writeToOutput(OutputStream outputStream) throws IOException {
        outputStream.write(this.outputStream.toByteArray());
    }
}

