/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.views.property;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.OseeUiActivator;
import org.eclipse.osee.framework.ui.plugin.views.property.PropertyId;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ImagePropertyDescriptor
extends PropertyDescriptor {
    public ImagePropertyDescriptor(PropertyId propertyId) {
        super((Object)propertyId, propertyId.getDisplayName());
        this.setCategory(propertyId.getCategoryName());
        this.setLabelProvider(new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return "Image";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    public static Object fromModel(Image image) {
        return image;
    }

    public static Image toModel(Object object) {
        return (Image)object;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        DialogCellEditor editor = new DialogCellEditor(parent){

            protected Object openDialogBox(Control cellEditorWindow) {
                FileDialog dialog = new FileDialog(cellEditorWindow.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"jpg", "bmp", "png"});
                dialog.open();
                String fileName = dialog.getFileName();
                if (Strings.isValid((String)fileName)) {
                    try {
                        Image image = ImageDescriptor.createFromURL((URL)new File(fileName).toURI().toURL()).createImage();
                        return image;
                    }
                    catch (MalformedURLException ex) {
                        OseeLog.log(OseeUiActivator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
                return null;
            }

            protected void updateContents(Object value) {
                Label label = this.getDefaultLabel();
                if (label == null) {
                    return;
                }
                String text = "";
                if (value != null) {
                    text = ImagePropertyDescriptor.this.getLabelProvider().getText(value);
                }
                label.setText(text);
            }
        };
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }
}

