/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.util;

import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ViewPartUtil {
    public static int startMultiView(String viewID) {
        IViewReference[] viewRefs;
        TreeSet<Integer> set = new TreeSet<Integer>();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = viewRefs = page.getViewReferences();
        int n = viewRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewRef = iViewReferenceArray[n2];
            if (viewRef.getId().equals(viewID)) {
                try {
                    set.add(new Integer(viewRef.getSecondaryId()));
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            ++n2;
        }
        Iterator iter = set.iterator();
        boolean found = false;
        int secondaryId = 1;
        while (iter.hasNext() && !found) {
            if ((Integer)iter.next() != secondaryId) {
                found = true;
                continue;
            }
            ++secondaryId;
        }
        try {
            page.showView(viewID, Integer.toString(secondaryId), 1);
        }
        catch (PartInitException partInitException) {
            XConsoleLogger.err((String)("COULD NOT FIND " + viewID + ", with ID # = " + secondaryId), (Object[])new Object[0]);
        }
        return secondaryId;
    }

    public static IViewPart openOrShowView(String viewId) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            return page.showView(viewId);
        }
        catch (PartInitException e1) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Launch Error", (String)("Couldn't Launch " + viewId + "\n\n" + e1.getMessage()));
            return null;
        }
    }
}

