/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.util;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.ui.plugin.util.GetChildrenJob;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.IContentProviderRunnable;
import org.eclipse.osee.framework.ui.swt.ITreeNode;
import org.eclipse.osee.framework.ui.swt.TreeNode;

public class JobbedNode
extends TreeNode {
    private static final long serialVersionUID = 2285210369260889786L;
    private static final JobbedNode LOADING_NODE = new JobbedNode("Loading...");
    private static final JobbedNode CANCELLED_NODE = new JobbedNode("Cancelled");
    private static final Object[] LOADING = new Object[]{LOADING_NODE};
    private static final Object[] CANCELLED = new Object[]{CANCELLED_NODE};
    private final Viewer viewer;
    private final IContentProviderRunnable providerRunnable;
    private boolean expand = false;

    private JobbedNode(String title) {
        super(null, null, (Object)title);
        this.viewer = null;
        this.providerRunnable = null;
    }

    public JobbedNode(Object backingData, Viewer viewer, IContentProviderRunnable providerRunnable) {
        this(backingData, viewer, providerRunnable, null);
    }

    public JobbedNode(Object backingData, Viewer viewer, IContentProviderRunnable providerRunnable, JobbedNode parent) {
        super((ITreeNode)parent, null, backingData);
        this.viewer = viewer;
        this.providerRunnable = providerRunnable;
    }

    public Object[] getChildren() {
        if (this.children == null && this.providerRunnable != null) {
            this.children = LOADING;
            Jobs.startJob((Job)new GetChildrenJob(null, this.viewer, this, this.providerRunnable));
        }
        return this.children;
    }

    public void cancelled() {
        this.cancelled(CANCELLED);
    }

    public void cancelled(Exception ex) {
        this.cancelled(new Object[]{ex});
    }

    private void cancelled(Object[] children) {
        this.children = children;
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                JobbedNode.this.viewer.refresh();
            }
        });
    }

    public void setChildren(Object[] objChildren) {
        super.setChildren(objChildren);
        if (this.expand && this.viewer instanceof TreeViewer) {
            final TreeViewer treeViewer = (TreeViewer)this.viewer;
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    treeViewer.refresh();
                    treeViewer.expandToLevel(2);
                }
            });
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean expand) {
        this.expand = expand;
        if (this.children != null) {
            Object[] objectArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof JobbedNode) {
                    ((JobbedNode)((Object)obj)).refresh(true);
                }
                ++n2;
            }
        }
        this.children = null;
    }

    protected ITreeNode getChild(Object backingData) {
        return new JobbedNode(backingData, this.viewer, this.providerRunnable, this);
    }
}

