/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.orcs.rest.model.ArtifactIdReportColumn;
import org.eclipse.osee.orcs.rest.model.ArtifactTypeReportColumn;
import org.eclipse.osee.orcs.rest.model.AttributeReportColumn;
import org.eclipse.osee.orcs.rest.model.ReportColumn;

public class ReportLevel {
    private final String levelName;
    private int depth = 0;
    private final List<ReportColumn> columns = new LinkedList<ReportColumn>();
    private Boolean filtered = false;
    private RelationTypeSide relation = null;

    public ReportLevel(String levelName) {
        this.levelName = levelName;
    }

    public ReportLevel column(String columnName) {
        this.columns.add(new ArtifactIdReportColumn(columnName));
        return this;
    }

    public ReportLevel column(String columnName, AttributeTypeToken type) {
        this.columns.add(new AttributeReportColumn(columnName, type));
        return this;
    }

    public ReportLevel column(AttributeTypeToken type) {
        this.columns.add(new AttributeReportColumn(type.getName(), type));
        return this;
    }

    public ReportLevel type(String columnName) {
        this.columns.add(new ArtifactTypeReportColumn(columnName));
        return this;
    }

    public void filter(AttributeTypeToken type, String filterRegex) {
        for (ReportColumn column : this.getColumnsOfType(type)) {
            column.addFilter(filterRegex);
        }
    }

    public Boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered() {
        this.filtered = true;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public List<ReportColumn> getColumns() {
        return this.columns;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public RelationTypeSide getRelation() {
        return this.relation;
    }

    public void setRelation(RelationTypeSide relation) {
        this.relation = relation;
    }

    private List<ReportColumn> getColumnsOfType(AttributeTypeToken type) {
        LinkedList<ReportColumn> results = new LinkedList<ReportColumn>();
        for (ReportColumn column : this.columns) {
            AttributeReportColumn attrColumn;
            if (!(column instanceof AttributeReportColumn) || !(attrColumn = (AttributeReportColumn)column).getType().equals(type)) continue;
            results.add(attrColumn);
        }
        return results;
    }
}

