/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.gpg.bc.internal.BCText;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKey;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyLocator;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyPassphrasePrompt;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;

public class BouncyCastleGpgSigner
extends GpgSigner {
    private static void registerBouncyCastleProviderIfNecessary() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public BouncyCastleGpgSigner() {
        BouncyCastleGpgSigner.registerBouncyCastleProviderIfNecessary();
    }

    public boolean canLocateSigningKey(@Nullable String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt = new BouncyCastleGpgKeyPassphrasePrompt(credentialsProvider);){
                BouncyCastleGpgKey gpgKey = this.locateSigningKey(gpgSigningKey, committer, passphrasePrompt);
                boolean bl = gpgKey != null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException | NoSuchAlgorithmException | NoSuchProviderException | PGPException e) {
            return false;
        }
    }

    private BouncyCastleGpgKey locateSigningKey(@Nullable String gpgSigningKey, PersonIdent committer, BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt) throws CanceledException, UnsupportedCredentialItem, IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, URISyntaxException {
        if (gpgSigningKey == null || gpgSigningKey.isEmpty()) {
            gpgSigningKey = String.valueOf('<') + committer.getEmailAddress() + '>';
        }
        BouncyCastleGpgKeyLocator keyHelper = new BouncyCastleGpgKeyLocator(gpgSigningKey, passphrasePrompt);
        return keyHelper.findSecretKey();
    }

    public void sign(@NonNull CommitBuilder commit, @Nullable String gpgSigningKey, @NonNull PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BouncyCastleGpgKeyPassphrasePrompt passphrasePrompt = new BouncyCastleGpgKeyPassphrasePrompt(credentialsProvider);){
                BouncyCastleGpgKey gpgKey = this.locateSigningKey(gpgSigningKey, committer, passphrasePrompt);
                PGPSecretKey secretKey = gpgKey.getSecretKey();
                if (secretKey == null) {
                    throw new JGitInternalException(BCText.get().unableToSignCommitNoSecretKey);
                }
                JcePBESecretKeyDecryptorBuilder decryptorBuilder = new JcePBESecretKeyDecryptorBuilder().setProvider("BC");
                PGPPrivateKey privateKey = null;
                if (!passphrasePrompt.hasPassphrase()) {
                    try {
                        privateKey = secretKey.extractPrivateKey(decryptorBuilder.build(new char[0]));
                    }
                    catch (PGPException pGPException) {
                        // empty catch block
                    }
                }
                if (privateKey == null) {
                    char[] passphrase = passphrasePrompt.getPassphrase(secretKey.getPublicKey().getFingerprint(), gpgKey.getOrigin());
                    privateKey = secretKey.extractPrivateKey(decryptorBuilder.build(passphrase));
                }
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), 8).setProvider("BC"));
                signatureGenerator.init(0, privateKey);
                PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
                subpacketGenerator.setIssuerFingerprint(false, secretKey.getPublicKey());
                signatureGenerator.setHashedSubpackets(subpacketGenerator.generate());
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                Throwable throwable2 = null;
                Object var16_21 = null;
                try (BCPGOutputStream out = new BCPGOutputStream((OutputStream)new ArmoredOutputStream((OutputStream)buffer));){
                    signatureGenerator.update(commit.build());
                    signatureGenerator.generate().encode((OutputStream)out);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                commit.setGpgSignature(new GpgSignature(buffer.toByteArray()));
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException | NoSuchAlgorithmException | NoSuchProviderException | PGPException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

