/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.util;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryBuilder;

public abstract class AbstractConfigResource {
    protected final AtsApi atsApi;
    protected final OrcsApi orcsApi;
    private final ArtifactTypeToken artifactType;
    private final QueryBuilder query;

    public AbstractConfigResource(ArtifactTypeToken artifactType, AtsApi atsApi, OrcsApi orcsApi) {
        this.artifactType = artifactType;
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ArtifactToken> get() {
        return this.query.andIsOfType(new ArtifactTypeToken[]{this.artifactType}).asArtifactTokens();
    }

    @GET
    @Path(value="details")
    @Produces(value={"application/json"})
    public List<IAtsConfigObject> getObjectsJson() {
        ArrayList<IAtsConfigObject> configs = new ArrayList<IAtsConfigObject>();
        for (ArtifactToken art : this.query.andTypeEquals(new ArtifactTypeToken[]{this.artifactType}).getResults()) {
            configs.add(AtsObjects.getConfigObject((ArtifactToken)art, (AtsApi)this.atsApi));
        }
        return configs;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public ArtifactToken getObjectJson(@PathParam(value="id") ArtifactId artifactId) {
        return this.query.andId(artifactId).asArtifactToken();
    }

    @GET
    @Path(value="{id}/details")
    @Produces(value={"application/json"})
    public IAtsConfigObject getObjectDetails(@PathParam(value="id") ArtifactId artifactId) {
        return AtsObjects.getConfigObject((ArtifactToken)this.atsApi.getQueryService().getArtifact(artifactId), (AtsApi)this.atsApi);
    }
}

