/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.sync.jira;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.JiraTask;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.SyncSprint;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class SyncTeam {
    Collection<IAtsTeamDefinition> teamDefs = new ArrayList<IAtsTeamDefinition>();
    Map<String, SyncSprint> jiraSprintStrToSyncSprints = new HashMap<String, SyncSprint>();
    Map<String, JiraTask> atsIdToTask = new HashMap<String, JiraTask>();
    Collection<SyncSprint> syncSprints = new ArrayList<SyncSprint>();
    IAgileTeam agileTeam;
    private final Long agileTeamId = 6915488L;
    private final XResultData results = new XResultData();
    private final List<IAtsTeamWorkflow> backlogTeamWfs = new ArrayList<IAtsTeamWorkflow>();
    private final List<IAtsTeamWorkflow> jiraTeamWfs = new ArrayList<IAtsTeamWorkflow>();

    public Long getAgileTeamId() {
        return this.agileTeamId;
    }

    public Collection<IAtsTeamDefinition> getTeamDefs() {
        return this.teamDefs;
    }

    public void setTeamDefs(Collection<IAtsTeamDefinition> teamDefs) {
        this.teamDefs = teamDefs;
    }

    public IAgileTeam getAgileTeam() {
        return this.agileTeam;
    }

    public void setAgileTeam(IAgileTeam agileTeam) {
        this.agileTeam = agileTeam;
    }

    public XResultData getResults() {
        return this.results;
    }

    public SyncSprint getOrCreateSyncSprint(String jiraSprint) {
        SyncSprint syncSprint = this.jiraSprintStrToSyncSprints.get(jiraSprint);
        if (syncSprint == null) {
            boolean found = false;
            for (SyncSprint sSprint : this.syncSprints) {
                if (!sSprint.getSprint().getName().contains(jiraSprint)) continue;
                sSprint.setJiraSprintName(jiraSprint);
                syncSprint = sSprint;
                this.jiraSprintStrToSyncSprints.put(jiraSprint, sSprint);
                found = true;
                break;
            }
            if (!found) {
                syncSprint = new SyncSprint();
                this.syncSprints.add(syncSprint);
                syncSprint.setJiraSprintName(jiraSprint);
                this.jiraSprintStrToSyncSprints.put(jiraSprint, syncSprint);
            }
        }
        return syncSprint;
    }

    public SyncSprint getOrCreateSyncSprint(IAgileSprint sprint) {
        SyncSprint syncSprint = new SyncSprint();
        syncSprint.setSprint(sprint);
        this.syncSprints.add(syncSprint);
        return syncSprint;
    }

    public void addTeamDef(IAtsTeamDefinition teamDef) {
        this.teamDefs.add(teamDef);
    }

    public Map<String, JiraTask> getAtsIdToTask() {
        return this.atsIdToTask;
    }

    public void setAtsIdToTask(Map<String, JiraTask> atsIdToTask) {
        this.atsIdToTask = atsIdToTask;
    }

    public void addAtsIdToTask(String atsId, JiraTask jTask) {
        this.getAtsIdToTask().put(atsId, jTask);
    }

    public SyncSprint getSyncSprint(String sprint) {
        return this.jiraSprintStrToSyncSprints.get(sprint);
    }

    public void addBacklogTeamWf(IAtsTeamWorkflow teamWf) {
        this.backlogTeamWfs.add(teamWf);
    }

    public void addJiraTeamWf(IAtsTeamWorkflow teamWf) {
        this.jiraTeamWfs.add(teamWf);
    }

    public List<IAtsTeamWorkflow> getBacklogTeamWfs() {
        return this.backlogTeamWfs;
    }

    public List<IAtsTeamWorkflow> getJiraTeamWfs() {
        return this.jiraTeamWfs;
    }

    public Collection<SyncSprint> getSyncSprints() {
        return this.syncSprints;
    }
}

