/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.operations;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class FixWorkDefinitionToAttributeConversion
implements IAtsDatabaseConversion {
    public void run(XResultData rd, boolean reportOnly, AtsApi atsApi) {
        LinkedList artIdList = new LinkedList();
        artIdList.addAll(atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAttr((AttributeTypeId)AtsAttributeTypes.WorkflowDefinition, AtsWorkDefinitionTokens.WorkDef_Team_Default.getName(), new QueryOption[0]).getItemIds());
        List subDivide = Collections.subDivide(artIdList, (int)500);
        int size = subDivide.size();
        int count = 1;
        for (Collection artIds : subDivide) {
            String msg = String.format("WorkItem Set: Processing %s / %s\n", count++, size);
            rd.logf(msg, new Object[0]);
            LinkedList<Long> ids = new LinkedList<Long>();
            for (ArtifactId art : artIds) {
                ids.add(art.getId());
            }
            Collection artSet = atsApi.getQueryService().getArtifacts(ids);
            for (ArtifactToken art : artSet) {
                IAtsWorkDefinition computeWorkDefinition;
                IAtsTeamWorkflow teamWf = atsApi.getWorkItemService().getTeamWf(art);
                IAtsWorkDefinition workDefinition = atsApi.getWorkDefinitionService().getWorkDefinition((IAtsWorkItem)teamWf);
                if (workDefinition.equals(computeWorkDefinition = atsApi.getWorkDefinitionService().computeWorkDefinition((IAtsWorkItem)teamWf, false))) continue;
                String log = String.format("Work Def [%s] doesn't match computed [%s] for %s", workDefinition, computeWorkDefinition, teamWf.toStringWithId());
                rd.error(log);
            }
        }
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("Fix/Validate Work Definition to attributes conversion....\n");
        return data.toString();
    }

    public String getName() {
        return "Fix/Validate Work Definition To Attributes";
    }
}

