/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskNameProviderToken;
import org.eclipse.osee.ats.api.task.create.IAtsChangeReportTaskNameProvider;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.task.AbstractAtsTaskServiceCore;
import org.eclipse.osee.ats.core.task.ChangeReportTaskNameProviderService;
import org.eclipse.osee.ats.core.task.CreateChangeReportTasksOperation;
import org.eclipse.osee.ats.core.task.CreateTasksOperation;
import org.eclipse.osee.ats.core.workflow.Task;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public class AtsTaskService
extends AbstractAtsTaskServiceCore {
    public AtsTaskService(AtsApi atsApi) {
        super(atsApi);
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData, XResultData results) {
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet(newTaskData.getCommitComment(), AtsCoreUsers.SYSTEM_USER);
        return this.createTasks(newTaskData, changes, results);
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData, IAtsChangeSet changes, XResultData results) {
        return this.createTasks(newTaskData, changes, results, new HashMap<Long, IAtsTeamWorkflow>());
    }

    public Collection<IAtsTask> createTasks(NewTaskData newTaskData, IAtsChangeSet changes, XResultData results, Map<Long, IAtsTeamWorkflow> idToTeamWf) {
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        CreateTasksOperation operation = new CreateTasksOperation(newTaskData, this.atsApi, results);
        operation.setIdToTeamWf(idToTeamWf);
        operation.validate();
        if (results.isSuccess()) {
            operation.run(changes);
            if (results.isSuccess()) {
                for (JaxAtsTask task : operation.getTasks()) {
                    tasks.add(this.atsApi.getWorkItemService().getTask(this.atsApi.getQueryService().getArtifact(task.getId())));
                }
            }
        }
        return tasks;
    }

    public Collection<IAtsTask> createTasks(NewTaskDatas newTaskDatas) {
        CreateTasksOperation operation = new CreateTasksOperation(newTaskDatas, this.atsApi, new XResultData());
        XResultData results = operation.validate();
        if (results.isErrors()) {
            throw new OseeStateException("Error validating task creation - " + results.toString(), new Object[0]);
        }
        operation.run();
        if (results.isErrors()) {
            throw new OseeStateException("Error creating tasks - " + results.toString(), new Object[0]);
        }
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        for (JaxAtsTask task : operation.getTasks()) {
            tasks.add(this.atsApi.getWorkItemService().getTask(this.atsApi.getQueryService().getArtifact(task.getId())));
        }
        return tasks;
    }

    public Collection<IAtsTask> createTasks(IAtsTeamWorkflow teamWf, List<String> titles, List<AtsUser> assignees, Date createdDate, AtsUser createdBy, String relatedToState, String taskWorkDef, Map<AttributeTypeToken, List<Object>> attributes, IAtsChangeSet changes) {
        NewTaskData tasks = this.atsApi.getTaskService().getNewTaskData(teamWf, titles, assignees, createdDate, createdBy, relatedToState, taskWorkDef, attributes, changes.getComment());
        return this.createTasks(tasks, changes, new XResultData());
    }

    public ChangeReportTaskData createTasks(ChangeReportTaskData changeReportTaskData) {
        CreateChangeReportTasksOperation operation = new CreateChangeReportTasksOperation(changeReportTaskData, this.atsApi, null);
        return operation.run();
    }

    public ChangeReportTaskData createTasks(ChangeReportTaskData changeReportTaskData, IAtsChangeSet changes) {
        CreateChangeReportTasksOperation operation = new CreateChangeReportTasksOperation(changeReportTaskData, this.atsApi, changes);
        return operation.run();
    }

    public ChangeReportTaskData createTasks(ArtifactToken hostTeamWf, AtsTaskDefToken taskDefToken, ArtifactToken asUser) {
        ChangeReportTaskData data = new ChangeReportTaskData();
        data.setTaskDefToken(taskDefToken);
        data.setHostTeamWf(hostTeamWf);
        AtsUser atsUser = this.atsApi.getUserService().getUserById((ArtifactId)asUser);
        data.setAsUser(atsUser);
        return this.createTasks(data);
    }

    public IAtsChangeReportTaskNameProvider getChangeReportOptionNameProvider(ChangeReportTaskNameProviderToken token) {
        return ChangeReportTaskNameProviderService.getChangeReportOptionNameProvider((ChangeReportTaskNameProviderToken)token);
    }

    public IAtsTask getTask(ArtifactToken artifact) {
        if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
            throw new OseeArgumentException("Artifact %s must be of type Task", new Object[]{artifact.toStringWithId()});
        }
        return new Task(this.atsApi.getLogger(), this.atsApi, artifact);
    }
}

