/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.AttributeKey;
import org.eclipse.osee.ats.api.workflow.attr.AtsAttributeEndpointApi;
import org.eclipse.osee.ats.api.workflow.attr.AtsAttributes;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

@Path(value="attr")
public final class AtsAttributeEndpointImpl
implements AtsAttributeEndpointApi {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;
    @Context
    private HttpHeaders httpHeaders;

    public AtsAttributeEndpointImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public AtsAttributes get() {
        AtsAttributes attrs = new AtsAttributes();
        AttributeKey[] attributeKeyArray = AttributeKey.values();
        int n = attributeKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeKey key = attributeKeyArray[n2];
            attrs.add(key.name(), key.name(), key.getUrl().equals("N/A") ? key.getUrl() : String.valueOf(System.getProperty("OseeApplicationServer")) + key.getUrl());
            ++n2;
        }
        for (AttributeTypeGeneric attrType : this.orcsApi.tokenService().getAttributeTypes()) {
            if (!attrType.isEnumerated()) continue;
            attrs.add(attrType.getIdString(), attrType.getName(), String.valueOf(System.getProperty("OseeApplicationServer")) + "/ats/attr/" + attrType.getIdString() + "/");
        }
        return attrs;
    }

    public List<String> getValidValues(String idOrName) {
        LinkedList<String> values = new LinkedList<String>();
        if (idOrName.equals(AttributeKey.Assignee.name()) || idOrName.equals(AttributeKey.Originator.name())) {
            Collection active = this.atsApi.getUserService().getUsers(Active.Active);
            for (AtsUser user : active) {
                values.add(user.getName());
            }
        } else {
            AttributeTypeGeneric attrType = Strings.isNumeric((String)idOrName) ? this.orcsApi.tokenService().getAttributeType(Long.valueOf(idOrName)) : this.orcsApi.tokenService().getAttributeType(idOrName);
            this.getEnumValues(values, (AttributeTypeToken)attrType);
        }
        if (!values.isEmpty()) {
            Collections.sort(values);
        }
        return values;
    }

    private void getEnumValues(List<String> values, AttributeTypeToken attrType) {
        if (attrType.isEnumerated()) {
            AttributeTypeEnum enumeratedType = (AttributeTypeEnum)attrType;
            for (EnumToken entry : enumeratedType.getEnumValues()) {
                values.add(entry.getName());
            }
        }
    }
}

