/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util.health.check;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.health.HealthCheckResults;
import org.eclipse.osee.ats.api.util.health.IAtsHealthCheck;
import org.eclipse.osee.ats.rest.internal.util.health.check.AtsHealthQueries;
import org.eclipse.osee.framework.core.data.ArtifactToken;

public class TestTaskParent
implements IAtsHealthCheck {
    public void check(ArtifactToken artifact, IAtsWorkItem workItem, HealthCheckResults results, AtsApi atsApi, IAtsChangeSet changes) {
        if (workItem.isTask() && atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)workItem, AtsRelationTypes.TeamWfToTask_TeamWorkflow).isInvalid()) {
            this.error(results, workItem, "Task has no parent", new Object[0]);
        }
    }

    public void check(HealthCheckResults results, AtsApi atsApi) {
        for (IAtsWorkItem workItem : atsApi.getQueryService().getWorkItemsFromQuery(AtsHealthQueries.getArtIdsOfMuiltipleRelsOnSide(atsApi, atsApi.getAtsBranch(), AtsRelationTypes.TeamWfToTask_Task), new Object[0])) {
            this.error(results, workItem, "Orphaned Task ", new Object[]{workItem.toStringWithId()});
        }
    }
}

