/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.cpa;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.cpa.AtsCpaEndpointApi;
import org.eclipse.osee.ats.api.cpa.CpaBuild;
import org.eclipse.osee.ats.api.cpa.CpaConfig;
import org.eclipse.osee.ats.api.cpa.CpaConfigTool;
import org.eclipse.osee.ats.api.cpa.CpaDecision;
import org.eclipse.osee.ats.api.cpa.CpaProgram;
import org.eclipse.osee.ats.api.cpa.DecisionUpdate;
import org.eclipse.osee.ats.api.cpa.DuplicateCpa;
import org.eclipse.osee.ats.api.cpa.IAtsCpaService;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.rest.internal.cpa.CpaDuplicator;
import org.eclipse.osee.ats.rest.internal.cpa.CpaServiceRegistry;
import org.eclipse.osee.ats.rest.internal.cpa.CpaUtil;
import org.eclipse.osee.ats.rest.internal.cpa.DecisionLoader;
import org.eclipse.osee.ats.rest.internal.cpa.DecisionUpdater;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.orcs.OrcsApi;

public final class CpaResource
implements AtsCpaEndpointApi {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private final CpaServiceRegistry cpaRegistry;

    public CpaResource(OrcsApi orcsApi, AtsApi atsApi, CpaServiceRegistry cpaRegistry) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.cpaRegistry = cpaRegistry;
    }

    @GET
    @Produces(value={"text/html"})
    public String get() throws Exception {
        return AHTML.simplePage((String)"ATS CPA Resource");
    }

    @GET
    @Path(value="program")
    @Produces(value={"application/json"})
    public List<CpaProgram> getPrograms() throws Exception {
        ArrayList<CpaProgram> programs = new ArrayList<CpaProgram>();
        for (IAtsCpaService service : this.cpaRegistry.getServices()) {
            programs.addAll(service.getPrograms());
        }
        return programs;
    }

    @GET
    @Path(value="program/{id}")
    @Produces(value={"application/json"})
    public List<CpaDecision> getDecisionByProgram(@PathParam(value="id") String id, @QueryParam(value="open") Boolean open) throws Exception {
        return new DecisionLoader(this.cpaRegistry, this.atsApi, this.orcsApi).andOpen(open).andProgramId(id).load();
    }

    @GET
    @Path(value="program/{id}/build")
    @Produces(value={"application/json"})
    public List<CpaBuild> getBuildsByProgram(@PathParam(value="id") String programId) throws Exception {
        ArrayList<CpaBuild> builds = new ArrayList<CpaBuild>();
        for (IAtsCpaService service : this.cpaRegistry.getServices()) {
            builds.addAll(service.getBuilds(programId));
        }
        return builds;
    }

    @GET
    @Path(value="decision/{id}")
    @Produces(value={"application/json"})
    public Response getDecision(@PathParam(value="id") String id, @QueryParam(value="pcrSystem") String pcrSystem) throws Exception {
        URI uri = null;
        if (pcrSystem == null) {
            String actionUrl = AtsUtil.getActionUrl((String)id, (AtsApi)this.atsApi);
            uri = UriBuilder.fromUri((String)actionUrl).build(new Object[0]);
        } else {
            IAtsCpaService service = this.cpaRegistry.getServiceById(pcrSystem);
            uri = service.getLocation(UriBuilder.fromUri((String)CpaUtil.getCpaBasePath(this.atsApi)).build(new Object[0]), id);
        }
        return Response.seeOther((URI)uri).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="decision")
    public List<CpaDecision> putDecision(DecisionUpdate update) throws Exception {
        new DecisionUpdater(update, this.atsApi).update();
        return new DecisionLoader(this.cpaRegistry, this.atsApi, this.orcsApi).andCpaIds(update.getIds()).load();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="duplicate")
    public Response putDuplicate(DuplicateCpa duplicate) throws Exception {
        XResultData rd = new CpaDuplicator(duplicate, this.atsApi, this.cpaRegistry).duplicate();
        if (rd.isErrors()) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)rd.toString()).build();
        }
        CpaDecision decision = new DecisionLoader(this.cpaRegistry, this.atsApi, this.orcsApi).andCpaIds(Collections.singleton(duplicate.getCpaId())).load().iterator().next();
        return Response.ok().entity((Object)decision).build();
    }

    @GET
    @Path(value="config")
    @Produces(value={"application/json"})
    public CpaConfig getConfigs() throws Exception {
        CpaConfig config = new CpaConfig();
        for (EnumToken entry : AtsAttributeTypes.ApplicableToProgram.getEnumValues()) {
            config.getApplicabilityOptions().add(entry.getName());
        }
        for (IAtsCpaService service : this.cpaRegistry.getServices()) {
            config.getTools().add(new CpaConfigTool(service.getId()));
        }
        return config;
    }

    @GET
    @Path(value="config/tool/{id}")
    @Produces(value={"application/json"})
    public String getConfig(@PathParam(value="id") String id) throws Exception {
        for (IAtsCpaService service : this.cpaRegistry.getServices()) {
            if (!service.getId().equals(id)) continue;
            return service.getConfigJson();
        }
        throw new OseeWebApplicationException(Response.Status.BAD_REQUEST, String.format("Unknown CPA configuration [%s]", id), new Object[0]);
    }
}

