/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.define.rest.internal.SafetyInformationAccumulator;
import org.eclipse.osee.define.rest.internal.TraceAccumulator;
import org.eclipse.osee.define.rest.internal.TraceMatch;
import org.eclipse.osee.define.rest.internal.util.ComponentUtil;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.QueryFactory;

public class SafetyReportGenerator {
    private SafetyInformationAccumulator accumulator;
    private QueryFactory queryFactory;
    private ComponentUtil componentUtil;
    private final TraceMatch match = new TraceMatch("\\^SRS\\s*([^;]+);?", "\\[?(\\{[^\\}]+\\})(.*)");
    private final TraceAccumulator traces = new TraceAccumulator(".*\\.(java|ada|ads|adb|c|h)", this.match);
    private final ActivityLog activityLog;
    public static int SYSTEM_REQUIREMENT_INDEX = 4;
    public static int SUBSYSTEM_FUNCTION_INDEX = 5;
    public static int SUBSYSTEM_INDEX = 7;
    public static int SOFTWARE_REQUIREMENT_INDEX = 11;
    public static int CODE_UNIT_INDEX = 17;
    private final String[] columnHeadings = new String[]{"System Function", "Safety Criticality", "SFHA Hazard(s)", "Paragraph #", "System Requirement Name", "Subsystem Function", "Safety Criticality", CoreAttributeTypes.Subsystem.getName(), "Paragraph #", "Subsystem Requirement Name", "Development Assurance Level", CoreArtifactTypes.SoftwareRequirementMsWord.getName(), "Development Assurance Level", "Boeing Equivalent SW Qual Level", "Functional Category", "SW Partition", "SW CSU", "SW Code Unit"};

    public SafetyReportGenerator(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    private void init(OrcsApi orcsApi, BranchId branchId, ISheetWriter writer) {
        this.accumulator = new SafetyInformationAccumulator(this, writer);
        this.queryFactory = orcsApi.getQueryFactory();
        this.componentUtil = new ComponentUtil(branchId, orcsApi);
    }

    private void writeCell(String value, String[] currentRow, int col) {
        currentRow[col] = value;
    }

    public void runOperation(OrcsApi providedOrcs, BranchId branchId, String codeRoot, Writer providedWriter) throws IOException {
        ExcelXmlWriter writer = new ExcelXmlWriter(providedWriter);
        this.init(providedOrcs, branchId, (ISheetWriter)writer);
        boolean doTracability = false;
        if (codeRoot != null && !codeRoot.isEmpty()) {
            doTracability = true;
        }
        if (doTracability) {
            File root = new File(codeRoot);
            this.traces.extractTraces(root);
        }
        ArtifactReadable functionsFolder = (ArtifactReadable)this.queryFactory.fromBranch(branchId).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andNameEquals("System Functions").getResults().getExactlyOne();
        this.processSystemFunctions(functionsFolder, (ISheetWriter)writer);
        writer.endWorkbook();
    }

    private void processSystemFunctions(ArtifactReadable functionsFolder, ISheetWriter writer) throws IOException {
        writer.startSheet("report", this.columnHeadings.length);
        writer.writeRow((Object[])this.columnHeadings);
        Object[] currentRowValues = new String[this.columnHeadings.length];
        for (ArtifactReadable systemFunction : functionsFolder.getDescendants()) {
            String sevCat = this.getSeverityCategory(systemFunction);
            boolean isNHSeverity = false;
            if (Strings.isValid((String)sevCat) && "NH".equals(sevCat)) {
                isNHSeverity = true;
            }
            if (!systemFunction.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SystemFunctionMsWord}) || isNHSeverity) continue;
            this.writeCell(systemFunction.getName(), (String[])currentRowValues, 0);
            this.accumulator.reset(systemFunction);
            this.accumulator.buildSubsystemsRequirementsMap(systemFunction);
            this.writeCell(sevCat, (String[])currentRowValues, 1);
            this.writeSFHAInfo(systemFunction, sevCat, writer, (String[])currentRowValues, 2);
            StringBuilder paraNums = new StringBuilder();
            StringBuilder reqNames = new StringBuilder();
            boolean firstTime = true;
            for (ArtifactReadable systemRequirement : systemFunction.getRelated(CoreRelationTypes.Design_Requirement)) {
                if (!firstTime) {
                    paraNums.append(", ");
                    reqNames.append(", ");
                } else {
                    firstTime = false;
                }
                paraNums.append((String)systemRequirement.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)""));
                reqNames.append(systemRequirement.getName());
            }
            this.writeCell(paraNums.toString(), (String[])currentRowValues, 3);
            this.writeCell(reqNames.toString(), (String[])currentRowValues, SYSTEM_REQUIREMENT_INDEX);
            this.accumulator.output((String[])currentRowValues);
            writer.writeRow(currentRowValues);
        }
        writer.endSheet();
    }

    private String getSeverityCategory(ArtifactReadable systemFunction) {
        ResultSet results = systemFunction.getAttributes((AttributeTypeToken)CoreAttributeTypes.SeverityCategory);
        if (!results.isEmpty()) {
            if (systemFunction.getAttributes((AttributeTypeToken)CoreAttributeTypes.SeverityCategory).size() > 1) {
                this.activityLog.createEntry(CoreActivityTypes.OSEE_ERROR, new Object[]{"found too many sevCat attributes on " + systemFunction.toString()});
                return ((AttributeReadable)systemFunction.getAttributes((AttributeTypeToken)CoreAttributeTypes.SeverityCategory).iterator().next()).getDisplayableString();
            }
            return systemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.SeverityCategory);
        }
        this.activityLog.createEntry(CoreActivityTypes.OSEE_ERROR, new Object[]{"found no sevCat attribute on " + systemFunction.toString()});
        return "";
    }

    private void writeSFHAInfo(ArtifactReadable systemFunction, String sevCat, ISheetWriter writer, String[] currentRowValues, int col) throws IOException {
        ResultSet results = systemFunction.getRelated(CoreRelationTypes.Assessment_SafetyAssessment);
        if (results.isEmpty()) {
            this.writeCell("No SFHA Hazards found", currentRowValues, col);
        } else {
            this.writeCell(this.getSFHAHazards((ResultSet<ArtifactReadable>)results), currentRowValues, col);
        }
    }

    private String getSFHAHazards(ResultSet<ArtifactReadable> results) {
        StringBuilder sb = new StringBuilder();
        for (ArtifactReadable assessment : results) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(assessment.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, ""));
            sb.append(" ");
            sb.append(assessment.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Name, ""));
            sb.append(" ");
            sb.append((String)assessment.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.SFHA, (Object)""));
        }
        return sb.toString();
    }

    public Collection<String> getRequirementToCodeUnitsValues(ArtifactReadable softwareRequirement) {
        return this.traces.getFiles(softwareRequirement.getName());
    }

    public ComponentUtil getComponentUtil() {
        return this.componentUtil;
    }
}

