/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.resolvers;

import java.util.Collection;
import org.eclipse.osee.define.rest.importing.resolvers.AttributeBasedArtifactResolver;
import org.eclipse.osee.define.rest.importing.resolvers.DoorsBestFitArtifactResolver;
import org.eclipse.osee.define.rest.importing.resolvers.DoorsIdResolver;
import org.eclipse.osee.define.rest.importing.resolvers.GuidBasedArtifactResolver;
import org.eclipse.osee.define.rest.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.define.rest.importing.resolvers.IRoughArtifactTranslator;
import org.eclipse.osee.define.rest.importing.resolvers.NewArtifactImportResolver;
import org.eclipse.osee.define.rest.importing.resolvers.RoughArtifactTranslatorImpl;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public final class ArtifactResolverFactory {
    private ArtifactResolverFactory() {
    }

    public static IArtifactImportResolver createAlwaysNewArtifacts(TransactionBuilder transaction, ArtifactTypeToken primaryArtifactType) {
        ArtifactTypeToken secondaryArtifactType = CoreArtifactTypes.HeadingMsWord;
        if (primaryArtifactType.equals(CoreArtifactTypes.SubsystemRequirementHtml) || primaryArtifactType.equals(CoreArtifactTypes.SystemRequirementHtml)) {
            secondaryArtifactType = CoreArtifactTypes.HeadingHtml;
        }
        return ArtifactResolverFactory.createAlwaysNewArtifacts(transaction, primaryArtifactType, secondaryArtifactType);
    }

    public static IArtifactImportResolver createAlwaysNewArtifacts(TransactionBuilder transaction, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType) {
        RoughArtifactTranslatorImpl translator = new RoughArtifactTranslatorImpl();
        return new NewArtifactImportResolver(transaction, translator, primaryArtifactType, secondaryArtifactType, CoreArtifactTypes.DocumentDescriptionMsWord, CoreArtifactTypes.DesignDescriptionMsWord);
    }

    public static IArtifactImportResolver createResolver(TransactionBuilder transaction, ArtifactCreationStrategy strategy, ArtifactTypeToken primaryArtifactType, Collection<AttributeTypeToken> nonChangingAttributes, boolean createNewIfNotExist, boolean deleteUnmatchedArtifacts) {
        IArtifactImportResolver toReturn;
        switch (strategy) {
            case CREATE_ON_DIFFERENT_ATTRIBUTES: {
                toReturn = new AttributeBasedArtifactResolver(transaction, new RoughArtifactTranslatorImpl(), primaryArtifactType, CoreArtifactTypes.HeadingMsWord, nonChangingAttributes, createNewIfNotExist, deleteUnmatchedArtifacts);
                break;
            }
            case CREATE_ON_NEW_ART_GUID: {
                toReturn = new GuidBasedArtifactResolver(transaction, (IRoughArtifactTranslator)new RoughArtifactTranslatorImpl(), primaryArtifactType, CoreArtifactTypes.HeadingMsWord, createNewIfNotExist, deleteUnmatchedArtifacts);
                break;
            }
            case CREATE_ON_DOORS_BEST_FIT: {
                toReturn = new DoorsBestFitArtifactResolver(transaction, (IRoughArtifactTranslator)new RoughArtifactTranslatorImpl(), primaryArtifactType, CoreArtifactTypes.HeadingHtml, createNewIfNotExist, deleteUnmatchedArtifacts);
                break;
            }
            case INSERT_OR_OVERLAY: {
                toReturn = new DoorsIdResolver(transaction, (IRoughArtifactTranslator)new RoughArtifactTranslatorImpl(), primaryArtifactType, CoreArtifactTypes.HeadingHtml, createNewIfNotExist, deleteUnmatchedArtifacts);
                break;
            }
            default: {
                toReturn = ArtifactResolverFactory.createAlwaysNewArtifacts(transaction, primaryArtifactType);
            }
        }
        return toReturn;
    }

    public static enum ArtifactCreationStrategy {
        CREATE_NEW_ALWAYS,
        CREATE_ON_NEW_ART_GUID,
        CREATE_ON_DIFFERENT_ATTRIBUTES,
        CREATE_ON_DOORS_BEST_FIT,
        INSERT_OR_OVERLAY;

    }
}

