/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.order;

import org.eclipse.osee.orcs.core.internal.relation.order.HasOrderData;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderAccessor;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderChange;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderParser;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderStore;

public class OrderAccessorImpl
implements OrderAccessor {
    private final OrderParser parser;
    private final OrderStore storage;

    public OrderAccessorImpl(OrderParser parser, OrderStore storage) {
        this.parser = parser;
        this.storage = storage;
    }

    @Override
    public void load(HasOrderData data) {
        data.clear();
        String value = this.storage.getOrderData();
        this.parser.loadFromXml(data, value);
    }

    @Override
    public void store(HasOrderData data, OrderChange changeType) {
        if (changeType != OrderChange.NoChange && this.storage.isAccessible()) {
            String value = "";
            if (!data.isEmpty()) {
                value = this.parser.toXml(data);
            }
            this.storage.storeOrderData(changeType, value);
        }
    }
}

