/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.impl;

import java.util.Collection;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilder;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilderFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.relation.RelationNodeLoader;

public class RelationNodeLoaderImpl
implements RelationNodeLoader {
    private final DataLoaderFactory dataLoaderFactory;
    private final GraphBuilderFactory graphBuilderFactory;

    public RelationNodeLoaderImpl(DataLoaderFactory dataLoaderFactory, GraphBuilderFactory graphBuilderFactory) {
        this.dataLoaderFactory = dataLoaderFactory;
        this.graphBuilderFactory = graphBuilderFactory;
    }

    @Override
    public <T extends Artifact> Iterable<T> loadNodes(OrcsSession session, GraphData graph, Collection<Integer> ids, LoadLevel level) {
        GraphBuilder builder = this.graphBuilderFactory.createBuilderForGraph(graph);
        DataLoader loader = this.dataLoaderFactory.newDataLoaderFromIds(session, graph.getBranch(), ids);
        loader.withLoadLevel(level);
        loader.fromTransaction(graph.getTransaction());
        loader.fromBranchView(graph.getBranch().getViewId());
        loader.includeDeletedArtifacts();
        loader.load(null, builder);
        return RelationNodeLoaderImpl.getResults(builder);
    }

    private static <T> Iterable<T> getResults(GraphBuilder builder) {
        return builder.getArtifacts();
    }
}

