/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.ExportOptions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.search.BranchQuery;

public final class BranchExportCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "branch_export";
    }

    public String getDescription() {
        return "Export a specific set of branches into an exchange zip file.";
    }

    public String getUsage() {
        return "uri=<EXCHANGE_FILE_LOCATION> [compress=<TRUE|FALSE>] [minTx=<TX_ID>] [maxTx=<TX_ID>] [includeArchivedBranches=<TRUE|FALSE>] [excludeBranchIds=<BRANCH_IDS,...>] [includeBranchIds=<BRANCH_IDS>]";
    }

    public Callable<?> createCallable(Console console, ConsoleParameters params) {
        String exportFileName = params.get("uri");
        boolean includeArchivedBranches = params.getBoolean("includeArchivedBranches");
        PropertyStore options = new PropertyStore();
        if (params.exists("minTx")) {
            options.put(ExportOptions.MIN_TXS.name(), params.getLong("minTx"));
        }
        if (params.exists("maxTx")) {
            options.put(ExportOptions.MAX_TXS.name(), params.getLong("maxTx"));
        }
        List<String> excludeBranchIds = Arrays.asList(params.getArray("excludeBranchIds"));
        List<String> includeBranchIds = Arrays.asList(params.getArray("includeBranchIds"));
        OrcsBranch orcsBranch = this.getOrcsApi().getBranchOps();
        return new ExportBranchCallable(console, orcsBranch, exportFileName, options, includeArchivedBranches, includeBranchIds, excludeBranchIds, this.orcsApi);
    }

    private static class ExportBranchCallable
    extends CancellableCallable<URI> {
        private final Console console;
        private final OrcsBranch orcsBranch;
        private final PropertyStore options;
        private final String exportFileName;
        private final boolean includeArchivedBranches;
        private final List<String> includeBranchIds;
        private final List<String> excludeBranchIds;
        private final OrcsApi orcsApi;

        public ExportBranchCallable(Console console, OrcsBranch orcsBranch, String exportFileName, PropertyStore options, boolean includeArchivedBranches, List<String> includeBranchIds, List<String> excludeBranchIds, OrcsApi orcsApi) {
            this.console = console;
            this.orcsBranch = orcsBranch;
            this.options = options;
            this.exportFileName = exportFileName;
            this.includeArchivedBranches = includeArchivedBranches;
            this.includeBranchIds = includeBranchIds;
            this.excludeBranchIds = excludeBranchIds;
            this.orcsApi = orcsApi;
        }

        private List<BranchId> getBranchesToExport() {
            LinkedList<BranchId> branches = new LinkedList<BranchId>();
            BranchQuery branchQuery = this.orcsApi.getQueryFactory().branchQuery();
            if (this.includeBranchIds.isEmpty()) {
                ResultSet branchReadables = null;
                if (this.includeArchivedBranches) {
                    branchQuery.includeArchived();
                } else {
                    branchQuery.excludeArchived();
                }
                branchReadables = ((BranchQuery)branchQuery.andIsOfType(new BranchType[]{BranchType.WORKING, BranchType.BASELINE, BranchType.MERGE, BranchType.PORT, BranchType.SYSTEM_ROOT})).getResults();
                for (Branch branch : branchReadables) {
                    branches.add((BranchId)branch);
                }
            } else {
                for (String branchUuidString : this.includeBranchIds) {
                    branches.add((BranchId)((BranchQuery)branchQuery.andId(BranchId.valueOf((String)branchUuidString))).getResults().getExactlyOne());
                }
            }
            branchQuery = this.orcsApi.getQueryFactory().branchQuery();
            if (!this.excludeBranchIds.isEmpty()) {
                for (String branchUuidString : this.excludeBranchIds) {
                    Branch toExclude = (Branch)((BranchQuery)branchQuery.andId(BranchId.valueOf((String)branchUuidString))).getResults().getExactlyOne();
                    branches.remove(toExclude);
                }
            }
            return branches;
        }

        public URI call() throws Exception {
            Conditions.checkNotNullOrEmpty((String)this.exportFileName, (String)"exportFileName");
            List<BranchId> branches = this.getBranchesToExport();
            this.console.writeln("Exporting: [%s] branches", new Object[]{branches.size()});
            Callable callable = this.orcsBranch.exportBranch(branches, this.options, this.exportFileName);
            return (URI)callable.call();
        }
    }
}

