/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.admin;

import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;

public abstract class AbstractAdminCallable<T>
extends CancellableCallable<T> {
    private final Log logger;
    private final OrcsSession session;
    private Callable<?> innerWorker;

    public AbstractAdminCallable(Log logger, OrcsSession session) {
        this.logger = logger;
        this.session = session;
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected OrcsSession getSession() {
        return this.session;
    }

    public final T call() throws Exception {
        T result;
        long startTime = 0L;
        if (this.logger.isTraceEnabled()) {
            startTime = System.currentTimeMillis();
        }
        try {
            Conditions.checkNotNull((Object)this.session, (String)"session");
            result = this.innerCall();
        }
        catch (Throwable throwable) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Admin [%s] completed in [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Lib.getElapseString((long)startTime)});
            }
            throw throwable;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Admin [%s] completed in [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Lib.getElapseString((long)startTime)});
        }
        return result;
    }

    protected abstract T innerCall() throws Exception;

    protected <K> K callAndCheckForCancel(Callable<K> callable) throws Exception {
        this.checkForCancelled();
        this.setInnerWorker(callable);
        K result = callable.call();
        this.setInnerWorker(null);
        return result;
    }

    private synchronized void setInnerWorker(Callable<?> callable) {
        this.innerWorker = callable;
    }

    public void setCancel(boolean isCancelled) {
        super.setCancel(isCancelled);
        Callable<?> inner = this.innerWorker;
        if (inner != null && inner instanceof HasCancellation) {
            ((HasCancellation)inner).setCancel(isCancelled);
        }
    }
}

