/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.access;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.internal.access.UserGroupImpl;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class UserServiceImpl
implements UserService {
    private final OrcsApi orcsApi;
    private final ConcurrentHashMap<Thread, UserToken> threadToUser = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, UserToken> emailToUser = new ConcurrentHashMap();
    private final QueryBuilder query;

    public UserServiceImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
    }

    public IUserGroup getOseeAdmin() {
        return this.getUserGroup(CoreUserGroups.OseeAdmin);
    }

    public IUserGroup getOseeAccessAdmin() {
        return this.getUserGroup(CoreUserGroups.OseeAccessAdmin);
    }

    public IUserGroup getUserGroup(IUserGroupArtifactToken userGroup) {
        ArtifactToken art;
        ArtifactReadable userGroupArt = null;
        if (userGroup instanceof ArtifactReadable) {
            userGroupArt = (ArtifactReadable)userGroup;
        }
        if (userGroupArt == null && (art = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)userGroup).getArtifactOrSentinal()).isValid() && art instanceof ArtifactReadable) {
            userGroupArt = (ArtifactReadable)art;
        }
        if (userGroupArt != null) {
            return new UserGroupImpl((ArtifactToken)userGroupArt);
        }
        throw new OseeArgumentException("parameter must be artifact", new Object[0]);
    }

    public IUserGroup getUserGroup(ArtifactToken userGroupArt) {
        return new UserGroupImpl(userGroupArt);
    }

    public Collection<IUserGroupArtifactToken> getMyUserGroups() {
        throw new UnsupportedOperationException();
    }

    public boolean isInUserGroup(IUserGroupArtifactToken ... userGroups) {
        Collection<IUserGroupArtifactToken> myUserGroups = this.getMyUserGroups();
        IUserGroupArtifactToken[] iUserGroupArtifactTokenArray = userGroups;
        int n = userGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IUserGroupArtifactToken userGrp = iUserGroupArtifactTokenArray[n2];
            if (myUserGroups.contains(userGrp)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isUserMember(IUserGroupArtifactToken userGroup, Long id) {
        ArtifactToken art = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)userGroup).getArtifactOrSentinal();
        if (art.isInvalid()) {
            return false;
        }
        return this.getUserGroup(userGroup).isMember(id);
    }

    public Collection<UserToken> getUsers(IUserGroupArtifactToken userGroup) {
        throw new UnsupportedOperationException();
    }

    public boolean isUserMember(IUserGroupArtifactToken userGroup, ArtifactId user) {
        return this.isUserMember(userGroup, user.getId());
    }

    public UserToken getUser() {
        UserToken user = this.threadToUser.get(Thread.currentThread());
        if (user == null) {
            user = UserToken.SENTINEL;
        }
        return user;
    }

    private synchronized void ensureLoaded() {
        if (this.emailToUser.isEmpty()) {
            for (ArtifactReadable userArtifact : this.query.andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).asArtifacts()) {
                UserToken user = this.toUser(userArtifact);
                this.emailToUser.put(user.getEmail(), user);
            }
        }
    }

    private UserToken toUser(ArtifactReadable userArtifact) {
        return UserToken.create((long)userArtifact.getId(), (String)userArtifact.getName(), (String)((String)userArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Email)), (String)((String)userArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId)), (boolean)((Boolean)userArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Active)), (IUserGroupArtifactToken[])new IUserGroupArtifactToken[]{(IUserGroupArtifactToken)userArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.LoginId)});
    }

    public void setUserForCurrentThread(String userEmail) {
        ArtifactReadable userArtifact;
        this.ensureLoaded();
        UserToken user = this.emailToUser.get(userEmail);
        if (user == null && (userArtifact = this.query.andAttributeIs((AttributeTypeId)CoreAttributeTypes.Email, userEmail).asArtifact()).isValid()) {
            user = this.toUser(userArtifact);
        }
        if (user != null) {
            this.threadToUser.put(Thread.currentThread(), user);
        }
    }
}

