/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.writers.GenericReportBuilder;
import org.eclipse.osee.orcs.rest.internal.writers.GenericReportCode;
import org.eclipse.osee.orcs.rest.internal.writers.TemplateParser;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class PublishTemplateReport
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final QueryFactory queryApi;
    private final BranchToken branch;
    private final ArtifactId view;
    private final ArtifactId reportTemplateArt;
    private ExcelXmlWriter writer;
    private final GenericReportBuilder report;
    private final XResultData results;

    public PublishTemplateReport(OrcsApi orcsApi, BranchId branch, ArtifactId view, ArtifactId templateArt) {
        this.orcsApi = orcsApi;
        this.queryApi = orcsApi.getQueryFactory();
        this.branch = (BranchToken)((BranchQuery)this.queryApi.branchQuery().andId(branch)).getResultsAsId().getExactlyOne();
        this.view = view;
        this.reportTemplateArt = templateArt;
        this.results = new XResultData();
        this.report = new GenericReportBuilder(branch, view, orcsApi);
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            if (this.reportTemplateArt.isValid()) {
                this.writeReport();
            } else {
                this.results.errorf("Invalid Template Report artifact provided: %s", new Object[]{this.reportTemplateArt});
            }
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeReport() throws IOException {
        TemplateParser parser = new TemplateParser(this.orcsApi, (BranchId)this.branch, this.view, this.reportTemplateArt, this.results);
        parser.parseTemplateData(this.report);
        if (!this.results.isErrors()) {
            int numColumns = this.report.getColumnCount();
            this.writer.startSheet(parser.getTemplateArtifact().getName(), numColumns);
            this.finishFillingData();
            this.writer.endSheet();
        }
        this.writeResults();
    }

    private void writeResults() throws IOException {
        this.writer.startSheet("DebugInfo", 1);
        Object[] row = new String[]{"Result Text"};
        this.writer.writeRow(row);
        for (String result : this.results.getResults()) {
            row[0] = result;
            this.writer.writeRow(row);
        }
        this.writer.endSheet();
    }

    private void writeReportFromGenericReportCode() throws IOException {
        GenericReportCode generic = new GenericReportCode();
        generic.traceCode(this.report);
        int numColumns = this.report.getColumnCount();
        this.writer.startSheet("Subsystem to Code trace", numColumns);
        this.finishFillingData();
    }

    private void finishFillingData() throws IOException {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        this.report.getDataRowsFromQuery(data);
        for (Object[] row : data) {
            this.writer.writeRow(row);
        }
    }
}

