/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeMultiplicity;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.Multiplicity;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public interface ArtifactTypeToken
extends NamedId,
ArtifactTypeId {
    public static final ArtifactTypeToken SENTINEL = ArtifactTypeToken.valueOf(Id.SENTINEL, "Sentinel", new ArtifactTypeToken[0]);

    public static ArtifactTypeToken valueOf(long id, String name, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity((Long)id, NamespaceToken.OSEE, name, false, Arrays.asList(superTypes)).get();
    }

    public Multiplicity getMultiplicity(AttributeTypeToken var1);

    default public void getSingletonAttributeTypes(Set<AttributeTypeToken> attributeTypeTokens) {
    }

    public static ArtifactTypeToken create(Long id, NamespaceToken namespace, String name, boolean isAbstract, List<ArtifactTypeToken> superTypes) {
        return new AttributeMultiplicity(id, namespace, name, isAbstract, superTypes).get();
    }

    public <T> T getAttributeDefault(AttributeTypeGeneric<T> var1);

    public List<ComputedCharacteristicToken<?>> getValidComputedCharacteristics();

    public <T> boolean isComputedCharacteristicValid(ComputedCharacteristicToken<T> var1);

    default public boolean inheritsFromAny(Collection<ArtifactTypeToken> artTypes) {
        for (ArtifactTypeToken inheritType : artTypes) {
            if (!this.inheritsFrom(inheritType)) continue;
            return true;
        }
        return false;
    }

    default public boolean inheritsFrom(ArtifactTypeId otherType) {
        if (this.equals(otherType)) {
            return true;
        }
        for (ArtifactTypeToken superType : this.getSuperTypes()) {
            if (!superType.inheritsFrom(otherType)) continue;
            return true;
        }
        return false;
    }

    public List<ArtifactTypeToken> getDirectDescendantTypes();

    default public List<ArtifactTypeToken> getAllDescendantTypes() {
        ArrayList<ArtifactTypeToken> allDescendantTypes = new ArrayList<ArtifactTypeToken>();
        this.getAllDescendantTypes(allDescendantTypes);
        return allDescendantTypes;
    }

    default public void getAllDescendantTypes(List<ArtifactTypeToken> allDescendantTypes) {
        for (ArtifactTypeToken descendant : this.getDirectDescendantTypes()) {
            allDescendantTypes.add(descendant);
            descendant.getAllDescendantTypes(allDescendantTypes);
        }
    }

    public boolean isAbstract();

    public List<ArtifactTypeToken> getSuperTypes();

    public List<AttributeTypeToken> getValidAttributeTypes();

    public boolean isValidAttributeType(AttributeTypeId var1);

    public int getMin(AttributeTypeToken var1);

    public int getMax(AttributeTypeToken var1);

    public <T extends EnumToken> List<T> getValidEnumValues(AttributeTypeEnum<T> var1);

    public static ArtifactTypeToken create(Long id, NamespaceToken namespace, String name, boolean isAbstract, AttributeMultiplicity attributeTypes, List<ArtifactTypeToken> superTypes) {
        final class ArtifactTypeTokenImpl
        extends NamedIdBase
        implements ArtifactTypeToken {
            private final boolean isAbstract;
            private final List<ArtifactTypeToken> superTypes;
            private final List<ArtifactTypeToken> directDescendants = new ArrayList<ArtifactTypeToken>(4);
            private final AttributeMultiplicity attributeTypes;
            private final NamespaceToken namespace;

            public ArtifactTypeTokenImpl(Long id, NamespaceToken namespace, String name, boolean isAbstract, AttributeMultiplicity attributeTypes, List<ArtifactTypeToken> superTypes) {
                super(id, name);
                this.isAbstract = isAbstract;
                this.superTypes = superTypes;
                this.attributeTypes = attributeTypes;
                this.namespace = namespace;
                if (superTypes.size() > 1 && this.superTypes.contains(CoreArtifactTypes.Artifact)) {
                    throw new OseeArgumentException("Multiple super types for artifact type [%s] and and supertype Artifact", new Object[]{name});
                }
                for (ArtifactTypeToken superType : superTypes) {
                    attributeTypes.putAll(((ArtifactTypeTokenImpl)superType).attributeTypes);
                }
                for (ArtifactTypeToken superType : superTypes) {
                    ((ArtifactTypeTokenImpl)superType).addDirectDescendantType(this);
                }
            }

            @Override
            public boolean isAbstract() {
                return this.isAbstract;
            }

            @Override
            public List<ArtifactTypeToken> getSuperTypes() {
                return this.superTypes;
            }

            @Override
            public List<ArtifactTypeToken> getDirectDescendantTypes() {
                return this.directDescendants;
            }

            public void addDirectDescendantType(ArtifactTypeToken descendantType) {
                this.directDescendants.add(descendantType);
            }

            @Override
            public List<AttributeTypeToken> getValidAttributeTypes() {
                return this.attributeTypes.getValidAttributeTypes();
            }

            @Override
            public boolean isValidAttributeType(AttributeTypeId attributeType) {
                return this.attributeTypes.containsKey(attributeType);
            }

            @Override
            public int getMin(AttributeTypeToken attributeType) {
                if (this.isValidAttributeType(attributeType)) {
                    return this.attributeTypes.getMinimum(attributeType);
                }
                return -1;
            }

            @Override
            public int getMax(AttributeTypeToken attributeType) {
                if (this.isValidAttributeType(attributeType)) {
                    return this.attributeTypes.getMaximum(attributeType);
                }
                return -1;
            }

            @Override
            public Multiplicity getMultiplicity(AttributeTypeToken attributeType) {
                return this.attributeTypes.getMultiplicity(attributeType);
            }

            @Override
            public <T extends EnumToken> List<T> getValidEnumValues(AttributeTypeEnum<T> attributeType) {
                return this.attributeTypes.getValidEnumValues(attributeType);
            }

            @Override
            public <T> T getAttributeDefault(AttributeTypeGeneric<T> attributeType) {
                return this.attributeTypes.getAttributeDefault(attributeType);
            }

            @Override
            public void getSingletonAttributeTypes(Set<AttributeTypeToken> attributeTypeTokens) {
                this.attributeTypes.getSingletonAttributeTypes(attributeTypeTokens);
            }

            @Override
            public List<ComputedCharacteristicToken<?>> getValidComputedCharacteristics() {
                ArrayList validCharacteristics = new ArrayList();
                for (ComputedCharacteristicToken<?> computedCharacteristic : this.attributeTypes.getComputedCharacteristics()) {
                    if (!this.isComputedCharacteristicValid(computedCharacteristic)) continue;
                    validCharacteristics.add(computedCharacteristic);
                }
                return validCharacteristics;
            }

            @Override
            public <T> boolean isComputedCharacteristicValid(ComputedCharacteristicToken<T> computedCharacteristic) {
                return this.attributeTypes.getComputedCharacteristics().contains(computedCharacteristic) && computedCharacteristic.isMultiplicityValid(this);
            }

            public String getName() {
                String name = super.getName();
                if (this.namespace.notEqual((Id)NamespaceToken.OSEE) && !this.superTypes.isEmpty()) {
                    for (ArtifactTypeToken superType : this.superTypes) {
                        if (!name.equals(superType.getName())) continue;
                        name = String.format("%s %s", this.namespace.toString().toUpperCase(), name);
                        break;
                    }
                }
                return name;
            }

            public String toString() {
                String name = this.getName();
                return name == null ? super.toString() : name;
            }
        }
        return new ArtifactTypeTokenImpl(id, namespace, name, isAbstract, attributeTypes, superTypes);
    }
}

