/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.eclipse.osee.authentication.ldap.LdapSearchScope;
import org.eclipse.osee.authentication.ldap.internal.util.LdapEntry;
import org.eclipse.osee.authentication.ldap.internal.util.LdapUtil;
import org.eclipse.osee.authentication.ldap.internal.util.VariablePattern;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;

public final class LdapQuery {
    private final Log logger;
    private String base;
    private LdapSearchScope searchScope;
    private VariablePattern pattern;
    private final Set<String> itemsToReturn = new HashSet<String>();

    public LdapQuery(Log logger) {
        this.logger = logger;
    }

    public String getBase() {
        return this.base;
    }

    public LdapSearchScope getSearchScope() {
        return this.searchScope;
    }

    public VariablePattern getPattern() {
        return this.pattern;
    }

    public List<String> getParameters() {
        return this.pattern.getVariableNames();
    }

    public LdapQuery base(String base) {
        this.base = base;
        return this;
    }

    public LdapQuery scope(LdapSearchScope searchScope) {
        this.searchScope = searchScope;
        return this;
    }

    public LdapQuery pattern(VariablePattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public LdapQuery fields(Iterable<String> fields) {
        for (String field : fields) {
            this.itemsToReturn.add(field);
        }
        return this;
    }

    public LdapQuery field(String ... fields) {
        return this.fields(Arrays.asList(fields));
    }

    public ResultSet<LdapEntry> search(DirContext connection, Map<String, String> bindings) throws NamingException {
        String searchPattern = this.pattern.getIndexedPattern();
        String[] searchBindings = this.pattern.getVariableValues(bindings);
        String[] attributesToReturn = null;
        LdapSearchScope searchDepth = LdapUtil.getValue(this.searchScope, LdapSearchScope.SUBTREE_SCOPE);
        if (!this.itemsToReturn.isEmpty()) {
            attributesToReturn = this.itemsToReturn.toArray(new String[this.itemsToReturn.size()]);
        }
        LinkedList<LdapEntry> results = new LinkedList<LdapEntry>();
        this.search(results, connection, this.base, searchPattern, searchBindings, attributesToReturn, searchDepth);
        return ResultSets.newResultSet(results);
    }

    private void search(List<LdapEntry> results, DirContext connection, String searchPath, String expressionFilter, String[] filterArgs, String[] attributesToReturn, LdapSearchScope searchScope) throws NamingException {
        String queryParams;
        boolean traceEnabled;
        long endTime;
        long startTime;
        block10: {
            endTime = startTime = System.currentTimeMillis();
            traceEnabled = this.logger.isTraceEnabled();
            queryParams = String.format("scope[%s] searchPath[%s] filterExp[%s] filterArgs%s attributesToReturn%s", new Object[]{searchScope, searchPath, expressionFilter, filterArgs != null ? Arrays.deepToString(filterArgs) : "[]", attributesToReturn != null ? Arrays.deepToString(attributesToReturn) : "[]"});
            if (traceEnabled) {
                this.logger.trace("[%s] started - %s", new Object[]{this.getClass().getSimpleName(), queryParams});
            }
            try {
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(searchScope.asSearchDepth());
                searchControls.setReturningAttributes(attributesToReturn);
                NamingEnumeration<SearchResult> resultsEnum = connection.search(searchPath, expressionFilter, (Object[])filterArgs, searchControls);
                if (resultsEnum == null) break block10;
                try {
                    try {
                        AttributeProcessor processor = this.createProcessor();
                        while (resultsEnum.hasMore()) {
                            SearchResult rSet = resultsEnum.next();
                            LdapEntry entry = processor.process(rSet);
                            results.add(entry);
                        }
                    }
                    catch (PartialResultException ex) {
                        this.logger.warn((Throwable)ex, "LDAP Query partial results - %s", new Object[]{queryParams});
                        resultsEnum.close();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    resultsEnum.close();
                    throw throwable;
                }
                resultsEnum.close();
            }
            catch (Throwable throwable) {
                if (traceEnabled) {
                    endTime = System.currentTimeMillis() - startTime;
                    this.logger.trace("[%s] completed [%s] - %s", new Object[]{this.getClass().getSimpleName(), Lib.asTimeString((long)endTime), queryParams});
                }
                throw throwable;
            }
        }
        if (traceEnabled) {
            endTime = System.currentTimeMillis() - startTime;
            this.logger.trace("[%s] completed [%s] - %s", new Object[]{this.getClass().getSimpleName(), Lib.asTimeString((long)endTime), queryParams});
        }
    }

    private AttributeProcessor createProcessor() {
        return this.itemsToReturn.isEmpty() ? new AllAttributeProcessor() : new SelectiveAttributeProcessor();
    }

    private static class AllAttributeProcessor
    extends AttributeProcessor {
        private AllAttributeProcessor() {
        }

        @Override
        protected void process(SearchResult rSet, Map<String, Attribute> attributes) {
            NamingEnumeration<? extends Attribute> enumeration = rSet.getAttributes().getAll();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (attribute == null || attribute.size() <= 0) continue;
                attributes.put(attribute.getID(), attribute);
            }
        }
    }

    private static abstract class AttributeProcessor {
        private AttributeProcessor() {
        }

        public LdapEntry process(SearchResult rSet) {
            HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
            String distinguishedName = rSet.getNameInNamespace();
            BasicAttribute attribute = new BasicAttribute("dn", distinguishedName);
            attributes.put("dn", attribute);
            this.process(rSet, attributes);
            return new LdapEntry(attributes);
        }

        protected abstract void process(SearchResult var1, Map<String, Attribute> var2);
    }

    private class SelectiveAttributeProcessor
    extends AttributeProcessor {
        private SelectiveAttributeProcessor() {
        }

        @Override
        protected void process(SearchResult rSet, Map<String, Attribute> attributes) {
            for (String attName : LdapQuery.this.itemsToReturn) {
                Attribute attribute = rSet.getAttributes().get(attName);
                if (attribute == null || attribute.size() <= 0) continue;
                attributes.put(attName, attribute);
            }
        }
    }
}

