/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import javax.sql.DataSource;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.internal.JdbcConnectionImpl;
import org.eclipse.osee.jdbc.internal.JdbcConnectionInfo;
import org.eclipse.osee.jdbc.internal.JdbcConnectionProvider;
import org.eclipse.osee.jdbc.internal.PoolFactory;

public class PooledConnectionProvider
implements JdbcConnectionProvider {
    private final ConcurrentHashMap<String, LazyObject<DataSource>> dataSourceCache = new ConcurrentHashMap();
    private final PoolFactory poolFactory;

    public PooledConnectionProvider(PoolFactory poolFactory) {
        this.poolFactory = poolFactory;
    }

    @Override
    public JdbcConnectionImpl getConnection(JdbcConnectionInfo dbInfo) throws JdbcException {
        try {
            return new JdbcConnectionImpl(this.getDataSource(dbInfo).getConnection());
        }
        catch (Exception ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    private DataSource getDataSource(final JdbcConnectionInfo dbInfo) {
        LazyObject<DataSource> newProvider;
        String poolId = dbInfo.getId();
        LazyObject<DataSource> provider = this.dataSourceCache.get(poolId);
        if (provider == null && (provider = this.dataSourceCache.putIfAbsent(poolId, newProvider = new LazyObject<DataSource>(){

            protected FutureTask<DataSource> createLoaderTask() {
                Callable<DataSource> newCallable = PooledConnectionProvider.this.poolFactory.createDataSourceFetcher(dbInfo);
                return new FutureTask<DataSource>(newCallable);
            }
        })) == null) {
            provider = newProvider;
        }
        return (DataSource)provider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        PoolFactory poolFactory = this.poolFactory;
        synchronized (poolFactory) {
            try {
                this.poolFactory.disposePools(this.dataSourceCache.keySet());
            }
            catch (Exception exception) {}
            this.dataSourceCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getStatistics() {
        PoolFactory poolFactory = this.poolFactory;
        synchronized (poolFactory) {
            return this.poolFactory.getPoolStats();
        }
    }
}

