/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.IVariantData;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public interface JdbcStatement
extends AutoCloseable {
    public void runPreparedQuery(String var1, Object ... var2);

    public void runPreparedQuery(int var1, String var2, Object ... var3);

    public boolean next();

    @Override
    public void close();

    public void cancel();

    public InputStream getBinaryStream(String var1);

    public InputStream getAsciiStream(String var1);

    public String getString(String var1);

    public float getFloat(String var1);

    public long getLong(String var1);

    public int getInt(String var1);

    public boolean getBoolean(String var1);

    public Timestamp getTimestamp(String var1);

    public BigDecimal getBigDecimal(String var1);

    public Time getTime(String var1);

    public double getDouble(String var1);

    public Date getDate(String var1);

    public boolean wasNull();

    public int getColumnCount();

    public String getColumnName(int var1);

    public int getColumnType(int var1);

    public String getColumnTypeName(int var1);

    public Object getObject(int var1);

    public Object getObject(String var1);

    public int getRowCount();

    public boolean isNullable(int var1);

    public double getCallableDouble(int var1);

    public int getInt(int var1);

    public int getCallableInt(int var1);

    public long getLong(int var1);

    public String getString(int var1);

    public void updateObject(String var1, Object var2);

    public void updateRow();

    public IVariantData parse();

    default public Object loadAttributeValue(AttributeTypeToken attributeType) {
        Object value;
        if (attributeType.isBoolean()) {
            value = this.getBoolean("value");
        } else if (attributeType.isDouble()) {
            value = this.getDouble("value");
        } else if (attributeType.isInteger()) {
            value = this.getInt("value");
        } else if (attributeType.isLong()) {
            value = this.getLong("value");
        } else if (attributeType.isArtifactId()) {
            String id = this.getString("value");
            value = ArtifactId.valueOf((String)id);
        } else if (attributeType.isBranchId()) {
            value = BranchId.valueOf((String)this.getString("value"));
        } else if (attributeType.isDate()) {
            value = new Date(this.getLong("value"));
        } else {
            value = this.getString("value");
            if (attributeType.isEnumerated()) {
                value = Strings.intern((String)((String)value));
            }
        }
        return value;
    }
}

