/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.transaction;

import java.sql.Timestamp;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.OrcsChangeSet;
import org.eclipse.osee.orcs.core.ds.TransactionData;
import org.eclipse.osee.orcs.core.ds.TransactionResult;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.loader.data.TransactionDataImpl;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionProcessor;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionProcessorProvider;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionWriter;
import org.eclipse.osee.orcs.db.internal.transaction.TxWritePhaseEnum;

public final class CommitTransactionDatabaseTxCallable
extends AbstractDatastoreTxCallable<TransactionResult> {
    private final TransactionData transactionData;
    private final IdentityManager identityManager;
    private final TransactionProcessorProvider provider;
    private final TransactionWriter writer;
    private static final String UPDATE_BRANCH_STATE = "UPDATE osee_branch SET branch_state = ? WHERE branch_id = ? and branch_state = ?";

    public CommitTransactionDatabaseTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, IdentityManager identityManager, TransactionProcessorProvider provider, TransactionWriter writer, TransactionData transactionData) {
        super(logger, session, jdbcClient);
        this.identityManager = identityManager;
        this.provider = provider;
        this.writer = writer;
        this.transactionData = transactionData;
    }

    private TransactionId getNextTransactionId() {
        return this.identityManager.getNextTransactionId();
    }

    private void process(TxWritePhaseEnum phase) {
        Iterable<TransactionProcessor> processors = this.provider.getProcessor(phase);
        for (TransactionProcessor processor : processors) {
            processor.process((HasCancellation)this, this.getSession(), this.transactionData);
        }
    }

    @Override
    protected TransactionResult handleTxWork(JdbcConnection connection) {
        String comment = this.transactionData.getComment();
        BranchId branch = this.transactionData.getBranch();
        UserId author = this.transactionData.getAuthor();
        OrcsChangeSet changeSet = this.transactionData.getChangeSet();
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNull((Object)author, (String)"transaction author");
        Conditions.checkNotNullOrEmpty((String)comment, (String)"transaction comment");
        TransactionResultImpl result = null;
        if (!changeSet.isEmpty()) {
            this.process(TxWritePhaseEnum.BEFORE_TX_WRITE);
            TransactionReadable txRecord = this.createTransactionRecord(branch, author, comment, this.getNextTransactionId());
            this.writer.write(connection, txRecord, changeSet);
            Object[] params = new Object[]{BranchState.MODIFIED, branch, BranchState.CREATED};
            this.getJdbcClient().runPreparedUpdate(connection, UPDATE_BRANCH_STATE, params);
            result = new TransactionResultImpl(txRecord, changeSet);
        }
        return result;
    }

    @Override
    protected void handleTxException(Exception ex) {
        super.handleTxException(ex);
        this.writer.rollback();
    }

    @Override
    protected void handleTxFinally() {
        super.handleTxFinally();
        this.process(TxWritePhaseEnum.AFTER_TX_WRITE);
    }

    private TransactionReadable createTransactionRecord(BranchId branch, UserId author, String comment, TransactionId transaction) {
        TransactionDetailsType txType = TransactionDetailsType.NonBaselined;
        Timestamp transactionTime = GlobalTime.GreenwichMeanTimestamp();
        TransactionDataImpl created = new TransactionDataImpl(transaction.getId());
        created.setAuthor(author);
        created.setBranch(branch);
        created.setComment(comment);
        created.setCommitArt(ArtifactId.SENTINEL);
        created.setDate(transactionTime);
        created.setTxType(txType);
        return created;
    }

    private static final class TransactionResultImpl
    implements TransactionResult {
        private final TransactionReadable tx;
        private final OrcsChangeSet data;

        public TransactionResultImpl(TransactionReadable tx, OrcsChangeSet data) {
            this.tx = tx;
            this.data = data;
        }

        public TransactionReadable getTransaction() {
            return this.tx;
        }

        public OrcsChangeSet getChangeSet() {
            return this.data;
        }
    }
}

