/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.search.tagger.HasTagProcessor;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagProcessor;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerComparator;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;

public class SqlHandlerFactoryImpl
implements SqlHandlerFactory {
    private static final SqlHandlerComparator HANDLER_COMPARATOR = new SqlHandlerComparator();
    private final Map<Class<? extends Criteria>, Class<? extends SqlHandler<?>>> handleMap;
    private final TagProcessor tagProcessor;

    public SqlHandlerFactoryImpl(TagProcessor tagProcessor, Map<Class<? extends Criteria>, Class<? extends SqlHandler<?>>> handleMap) {
        this.handleMap = handleMap;
        this.tagProcessor = tagProcessor;
    }

    @Override
    public List<SqlHandler<?>> createHandlers(QueryData queryData) {
        ArrayList handlers = new ArrayList();
        int level = 0;
        for (List criteriaSet : queryData.getCriteriaSets()) {
            this.addHandlers(handlers, level, criteriaSet);
            ++level;
        }
        Collections.sort(handlers, HANDLER_COMPARATOR);
        return handlers;
    }

    private void addHandlers(List<SqlHandler<?>> handlers, int index, List<Criteria> criteriaSet) {
        for (Criteria criteria : criteriaSet) {
            SqlHandler<?> handler = this.createHandler(criteria);
            if (handler == null) continue;
            handler.setLevel(index);
            handlers.add(handler);
        }
    }

    @Override
    public SqlHandler<?> createHandler(Criteria criteria) {
        Class<?> key = criteria.getClass();
        Class<? extends SqlHandler<?>> handlerClass = this.handleMap.get(key);
        if (handlerClass == null) {
            throw new OseeStateException("No handler configured for criteria of %s", new Object[]{key});
        }
        return this.createHandler(criteria, handlerClass);
    }

    private <C extends Criteria, H extends SqlHandler<C>> SqlHandler<C> createHandler(C criteria, Class<H> item) {
        SqlHandler handler = null;
        try {
            handler = (SqlHandler)item.newInstance();
            handler.setData(criteria);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        if (handler instanceof HasTagProcessor) {
            ((HasTagProcessor)((Object)handler)).setTagProcessor(this.tagProcessor);
        }
        return handler;
    }
}

