/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import java.util.List;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.OrcsScriptSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ObjectQuerySqlContextFactoryImpl
implements QuerySqlContextFactory {
    private final SqlHandlerFactory handlerFactory;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;

    public ObjectQuerySqlContextFactoryImpl(SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlHandlerFactory handlerFactory) {
        this.joinFactory = joinFactory;
        this.jdbcClient = jdbcClient;
        this.handlerFactory = handlerFactory;
    }

    @Override
    public QuerySqlContext createQueryContext(OrcsSession session, QueryData queryData, QueryType queryType) {
        QuerySqlContext context = new QuerySqlContext(session, queryData.getOptions(), QuerySqlContext.ObjectQueryType.DYNAMIC_OBJECT);
        queryData.setQueryType(queryType);
        OrcsScriptSqlWriter writer = new OrcsScriptSqlWriter(this.joinFactory, this.jdbcClient, context, queryData);
        List<SqlHandler<?>> handlers = this.handlerFactory.createHandlers(queryData);
        ((AbstractSqlWriter)writer).build(handlers);
        return context;
    }
}

