/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.QueryData;

public abstract class AbstractSearchCallable
extends CancellableCallable<Integer> {
    private final Log logger;
    private final OrcsSession session;
    private final QueryData queryData;

    public AbstractSearchCallable(Log logger, OrcsSession session, QueryData queryData) {
        this.logger = logger;
        this.session = session;
        this.queryData = queryData;
    }

    protected OrcsSession getSession() {
        return this.session;
    }

    protected QueryData getQueryData() {
        return this.queryData;
    }

    public final Integer call() throws Exception {
        long startTime;
        long endTime = startTime = System.currentTimeMillis();
        Integer result = null;
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("%s [start] - [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.queryData});
            }
            result = this.innerCall();
        }
        finally {
            endTime = System.currentTimeMillis() - startTime;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("%s [%s] - completed [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Lib.asTimeString((long)endTime), this.queryData});
        }
        return result;
    }

    protected abstract Integer innerCall() throws Exception;
}

