/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.accessor;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.KeyValueDataAccessor;

public class OseeInfoDataAccessor
implements KeyValueDataAccessor {
    private static final String GET_VALUE_SQL = "SELECT osee_value FROM osee_info WHERE OSEE_KEY = ?";
    private static final String INSERT_KEY_VALUE_SQL = "INSERT INTO osee_info (OSEE_KEY, OSEE_VALUE) VALUES (?, ?)";
    private static final String DELETE_KEY_SQL = "DELETE FROM osee_info WHERE OSEE_KEY = ?";
    private static final String GET_KEYS_SQL = "SELECT osee_key FROM osee_info";
    private static final String ERROR_MESSAGE = "Unsupported modification - attempt to modify [%s].";
    private static final String BINARY_DATA_ERROR_MSG = "Unsupported modification - attempt to modify [%s]. This can be modified at startup through -D%s=<PATH>.";
    private static final String INDEX_STARTUP_ERROR_MSG = "Unsupported modification - attempt to modify [%s]. This is an launch time setting.";
    private Log logger;
    private JdbcClient jdbcClient;
    private boolean wasBinaryDataChecked = false;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcClient = jdbcService.getClient();
    }

    public void start() {
    }

    public void stop() {
        this.wasBinaryDataChecked = false;
    }

    public String getValue(String key) {
        String toReturn = null;
        toReturn = "osee.application.server.data".equals(key) ? this.getOseeApplicationServerData() : ("osee.check.tag.queue.on.startup".equals(key) ? String.valueOf(OseeInfoDataAccessor.isCheckTagQueueOnStartupAllowed()) : (String)this.jdbcClient.fetch((Object)"", GET_VALUE_SQL, new Object[]{key}));
        return toReturn;
    }

    public boolean putValue(String key, String value) {
        boolean wasUpdated = false;
        if ("osee.application.server.data".equals(key)) {
            throw new OseeStateException(BINARY_DATA_ERROR_MSG, new Object[]{"osee.application.server.data", "osee.application.server.data"});
        }
        if ("osee.check.tag.queue.on.startup".equals(key)) {
            throw new OseeStateException(INDEX_STARTUP_ERROR_MSG, new Object[]{"osee.check.tag.queue.on.startup"});
        }
        this.jdbcClient.runPreparedUpdate(DELETE_KEY_SQL, new Object[]{key});
        int updated = this.jdbcClient.runPreparedUpdate(INSERT_KEY_VALUE_SQL, new Object[]{key, value});
        wasUpdated = updated == 1;
        return wasUpdated;
    }

    public static boolean isCheckTagQueueOnStartupAllowed() {
        return Boolean.valueOf(System.getProperty("osee.check.tag.queue.on.startup", "false"));
    }

    public String getOseeApplicationServerData() {
        String toReturn = this.internalGetOseeApplicationServerData();
        if (!this.wasBinaryDataChecked) {
            File file = new File(toReturn);
            if (file.exists()) {
                this.logger.info("Application Server Data: [%s]", new Object[]{toReturn});
            } else {
                this.logger.warn("Application Server Data: [%s] does not exist and will be created", new Object[]{toReturn});
            }
            this.wasBinaryDataChecked = true;
        }
        return toReturn;
    }

    private String internalGetOseeApplicationServerData() {
        String userHome;
        String toReturn = System.getProperty("osee.application.server.data");
        if (!Strings.isValid((String)toReturn) && Strings.isValid((String)(userHome = System.getProperty("user.home")))) {
            toReturn = userHome;
        }
        return toReturn;
    }

    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        this.jdbcClient.runQuery(stmt -> {
            boolean bl = keys.add(stmt.getString("osee_key"));
        }, GET_KEYS_SQL, new Object[0]);
        return keys;
    }
}

