/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin;

import org.eclipse.osee.account.admin.AccountPreferences;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public interface Account
extends NamedId {
    public static final Account SENTINEL = Account.createSentinel();

    public boolean isActive();

    public String getEmail();

    public String getUserName();

    public AccountPreferences getPreferences();

    public AccountWebPreferences getWebPreferences();

    public static Account createSentinel() {
        final class AccountSentinel
        extends NamedIdBase
        implements Account {
            AccountSentinel() {
            }

            @Override
            public boolean isActive() {
                return false;
            }

            @Override
            public String getEmail() {
                return null;
            }

            @Override
            public String getUserName() {
                return null;
            }

            @Override
            public AccountPreferences getPreferences() {
                return null;
            }

            @Override
            public AccountWebPreferences getWebPreferences() {
                return null;
            }
        }
        return new AccountSentinel();
    }
}

