/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.AccountAdmin;
import org.eclipse.osee.account.admin.AccountLoginRequest;
import org.eclipse.osee.account.admin.AccountLoginRequestBuilder;
import org.eclipse.osee.account.admin.AccountPreferences;
import org.eclipse.osee.account.admin.AccountSession;
import org.eclipse.osee.account.admin.CreateAccountRequest;
import org.eclipse.osee.account.admin.CreateAccountRequestBuilder;
import org.eclipse.osee.account.rest.internal.AccountDataUtil;
import org.eclipse.osee.account.rest.internal.RequestInfo;
import org.eclipse.osee.account.rest.internal.RequestUtil;
import org.eclipse.osee.account.rest.model.AccountActiveData;
import org.eclipse.osee.account.rest.model.AccountDetailsData;
import org.eclipse.osee.account.rest.model.AccountInfoData;
import org.eclipse.osee.account.rest.model.AccountInput;
import org.eclipse.osee.account.rest.model.AccountLoginData;
import org.eclipse.osee.account.rest.model.AccountPreferencesData;
import org.eclipse.osee.account.rest.model.AccountPreferencesInput;
import org.eclipse.osee.account.rest.model.AccountSessionData;
import org.eclipse.osee.account.rest.model.AccountSessionDetailsData;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;

public class AccountOps {
    private final AccountAdmin accountAdmin;

    public AccountOps(AccountAdmin accountAdmin) {
        this.accountAdmin = accountAdmin;
    }

    public RequestInfo asRequestInfo(HttpServletRequest request) {
        final String userAgent = RequestUtil.getUserAgent(request);
        final String remoteAddress = RequestUtil.getClientIpAddrress(request);
        return new RequestInfo(){

            @Override
            public String getDetails() {
                return userAgent;
            }

            @Override
            public String getRemoteIpAddress() {
                return remoteAddress;
            }
        };
    }

    public List<AccountSessionDetailsData> getAccountSessionById(ArtifactId accountId) {
        ResultSet result = this.accountAdmin.getAccountSessionById(accountId);
        ArrayList<AccountSessionDetailsData> toReturn = new ArrayList<AccountSessionDetailsData>();
        for (AccountSession session : result) {
            toReturn.add(AccountDataUtil.asAccountAccessData(session));
        }
        return toReturn;
    }

    public AccountInfoData getAccountData(ArtifactId value) {
        ResultSet result = this.accountAdmin.getAccountById(value);
        Account account = (Account)result.getExactlyOne();
        return AccountDataUtil.asAccountData(account);
    }

    public AccountInfoData getAccountDataByName(String name) {
        ResultSet result = this.accountAdmin.getAccountByName(name);
        Account account = (Account)result.getExactlyOne();
        return AccountDataUtil.asAccountData(account);
    }

    public AccountSessionData doLogin(RequestInfo info, AccountLoginData input) {
        AccountLoginRequestBuilder builder = AccountLoginRequestBuilder.newBuilder();
        AccountLoginRequest request = builder.userName(input.getUsername()).password(input.getPassword()).scheme(input.getScheme()).accessedBy(info.getDetails()).remoteAddress(info.getRemoteIpAddress()).build();
        AccountSession session = this.accountAdmin.login(request);
        return AccountDataUtil.asSessionData(session);
    }

    public boolean doLogout(String token) {
        return this.accountAdmin.logout(token);
    }

    public AccountInfoData createAccount(String username, AccountInput input) {
        CreateAccountRequestBuilder builder = CreateAccountRequestBuilder.newBuilder();
        CreateAccountRequest request = builder.userName(username).displayName(input.getName()).email(input.getEmail()).active(input.isActive()).prefs(input.getPreferences()).build();
        ArtifactId id = this.accountAdmin.createAccount(request);
        ResultSet result = this.accountAdmin.getAccountById(id);
        Account account = (Account)result.getExactlyOne();
        return AccountDataUtil.asAccountData(account);
    }

    public void deleteAccount(ArtifactId accountId) {
        this.accountAdmin.deleteAccount(accountId);
    }

    public boolean setAccountActive(ArtifactId accountId, boolean active) {
        return this.accountAdmin.setActive(accountId, active);
    }

    public AccountActiveData isActive(ArtifactId accountId) {
        ResultSet result = this.accountAdmin.getAccountById(accountId);
        Account account = (Account)result.getExactlyOne();
        return AccountDataUtil.asAccountActiveData(account);
    }

    public List<AccountInfoData> getAllAccounts() {
        ArrayList<AccountInfoData> toReturn = new ArrayList<AccountInfoData>();
        for (Account account : this.accountAdmin.getAllAccounts()) {
            toReturn.add(AccountDataUtil.asAccountData(account));
        }
        return toReturn;
    }

    public AccountDetailsData getAccountDetailsData(ArtifactId accountId) {
        ResultSet result = this.accountAdmin.getAccountById(accountId);
        Account account = (Account)result.getExactlyOne();
        return AccountDataUtil.asAccountDetailsData(account);
    }

    public boolean editAccountWebPreferencesData(ArtifactId accountId, String key, String itemId, String newValue) {
        return this.accountAdmin.setAccountWebPreference(accountId, key, itemId, newValue);
    }

    public AccountWebPreferences getDefaultAccountWebPreferencesData(ArtifactId accountId) {
        ResultSet result = this.accountAdmin.getAccountById(accountId);
        Account account = (Account)result.getExactlyOne();
        AccountWebPreferences preferences = account.getWebPreferences();
        return preferences;
    }

    public AccountWebPreferences getAccountWebPreferencesData(ArtifactId id) {
        ResultSet result = this.accountAdmin.getAccountById(id);
        Account account = (Account)result.getExactlyOne();
        AccountWebPreferences preferences = account.getWebPreferences();
        return preferences;
    }

    public AccountPreferencesData getAccountPreferencesDataById(ArtifactId accountId) {
        ResultSet result = this.accountAdmin.getAccountById(accountId);
        Account account = (Account)result.getExactlyOne();
        AccountPreferences preferences = account.getPreferences();
        return AccountDataUtil.asAccountPreferencesData(preferences);
    }

    public AccountPreferencesData getAccountPreferencesDataByEmail(String email) {
        ResultSet result = this.accountAdmin.getAccountByEmail(email);
        Account account = (Account)result.getExactlyOne();
        AccountPreferences preferences = account.getPreferences();
        return AccountDataUtil.asAccountPreferencesData(preferences);
    }

    public boolean setAccountPreferences(ArtifactId accountId, AccountPreferencesInput input) {
        return this.accountAdmin.setAccountPreferences(accountId, input.getMap());
    }

    public AccountInfoData getAnonymousAccount() {
        ResultSet result = this.accountAdmin.getAnonymousAccount();
        Account account = (Account)result.getExactlyOne();
        return AccountDataUtil.asAccountData(account);
    }
}

