/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;

public final class BinaryContentUtils {
    private BinaryContentUtils() {
    }

    public static String getContentType(IResource resource) throws OseeCoreException {
        String mimeType;
        InputStream inputStream = null;
        try {
            try {
                inputStream = resource.getContent();
                mimeType = URLConnection.guessContentTypeFromStream(inputStream);
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex, "Error determining mime type for - [%s]", new Object[]{resource.getName()});
            }
        }
        finally {
            Lib.close((Closeable)inputStream);
        }
        if (mimeType == null && (mimeType = URLConnection.guessContentTypeFromName(resource.getLocation().toASCIIString())) == null) {
            mimeType = "application/*";
        }
        return mimeType;
    }

    public static String getContentType(String extension) {
        String contentType = null;
        contentType = Strings.isValid((String)extension) ? URLConnection.guessContentTypeFromName("dummy." + extension) : "application/*";
        return contentType;
    }
}

