/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.util;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxChange;

public final class Address
implements Comparable<Address> {
    private final Long branchId;
    private final int itemId;
    private final long transactionId;
    private final long gammaId;
    private ModificationType modType;
    private ApplicabilityId appId;
    private final TxChange txCurrent;
    private final boolean isBaseline;
    private TxChange correctedTxCurrent;
    private boolean purge;

    public Address(boolean isBaseline, Long branchId, int itemId, long transactionId, long gammaId, ModificationType modType, ApplicabilityId appId, TxChange txCurrent) {
        this.branchId = branchId;
        this.itemId = itemId;
        this.transactionId = transactionId;
        this.gammaId = gammaId;
        this.modType = modType;
        this.appId = appId;
        this.txCurrent = txCurrent;
        this.isBaseline = isBaseline;
    }

    public boolean isBaselineTx() {
        return this.isBaseline;
    }

    public boolean isSimilar(Address other) {
        return other != null && other.itemId == this.itemId && other.branchId.equals(this.branchId);
    }

    public boolean isSameTransaction(Address other) {
        return other != null && this.transactionId == other.transactionId;
    }

    public boolean hasSameGamma(Address other) {
        return other != null && this.gammaId == other.gammaId;
    }

    public boolean hasSameModType(Address other) {
        return this.modType == other.modType;
    }

    public boolean hasSameApplicability(Address other) {
        return this.appId.equals(other.getApplicabilityId());
    }

    public void ensureCorrectCurrent() {
        TxChange correctCurrent = TxChange.getCurrent((ModificationType)this.modType);
        if (this.txCurrent != correctCurrent) {
            this.correctedTxCurrent = correctCurrent;
        }
    }

    public void ensureNotCurrent() {
        if (this.txCurrent != TxChange.NOT_CURRENT) {
            this.correctedTxCurrent = TxChange.NOT_CURRENT;
        }
    }

    public boolean hasIssue() {
        return this.purge || this.correctedTxCurrent != null;
    }

    public TxChange getCorrectedTxCurrent() {
        return this.correctedTxCurrent;
    }

    public void setCorrectedTxCurrent(TxChange correctedTxCurrent) {
        this.correctedTxCurrent = correctedTxCurrent;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    public Long getBranchId() {
        return this.branchId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public long getGammaId() {
        return this.gammaId;
    }

    public ModificationType getModType() {
        return this.modType;
    }

    public void setModType(ModificationType modType) {
        this.modType = modType;
    }

    public ApplicabilityId getApplicabilityId() {
        return this.appId;
    }

    public void setApplicabilityId(ApplicabilityId appId) {
        this.appId = appId;
    }

    public TxChange getTxCurrent() {
        return this.txCurrent;
    }

    public boolean isBaseline() {
        return this.isBaseline;
    }

    public String toString() {
        return "Address [branchUuid=" + this.branchId + ", gammaId=" + this.gammaId + ", itemId=" + this.itemId + ", modType=" + this.modType + ", applicabilityId=" + this.appId + ", transactionId=" + this.transactionId + ", txCurrent=" + this.txCurrent + "]";
    }

    @Override
    public int compareTo(Address otherAddress) {
        if (this.transactionId != otherAddress.transactionId) {
            return (int)(this.transactionId - otherAddress.transactionId);
        }
        return (int)(this.gammaId - otherAddress.gammaId);
    }
}

