/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.RelationalConstants;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxChange;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.OrcsChangeSet;
import org.eclipse.osee.orcs.core.ds.OrcsData;
import org.eclipse.osee.orcs.core.ds.OrcsVisitor;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.db.internal.transaction.DaoToSql;
import org.eclipse.osee.orcs.db.internal.transaction.TransactionWriter;
import org.eclipse.osee.orcs.db.internal.transaction.TxSqlBuilder;

public class TxSqlBuilderImpl
implements OrcsVisitor,
TxSqlBuilder {
    private final SqlJoinFactory sqlJoinFactory;
    private final IdentityManager idManager;
    private TransactionId txId;
    private List<DaoToSql> binaryStores;
    private HashCollection<TransactionWriter.SqlOrderEnum, Object[]> dataItemInserts;
    private Map<TransactionWriter.SqlOrderEnum, IdJoinQuery> txNotCurrentsJoin;

    public TxSqlBuilderImpl(SqlJoinFactory sqlJoinFactory, IdentityManager idManager) {
        this.sqlJoinFactory = sqlJoinFactory;
        this.idManager = idManager;
        this.clear();
    }

    @Override
    public Set<Map.Entry<TransactionWriter.SqlOrderEnum, IdJoinQuery>> getTxNotCurrents() {
        return this.txNotCurrentsJoin != null ? this.txNotCurrentsJoin.entrySet() : Collections.emptySet();
    }

    @Override
    public List<Object[]> getInsertData(TransactionWriter.SqlOrderEnum key) {
        List toReturn = null;
        if (this.dataItemInserts != null) {
            toReturn = (List)this.dataItemInserts.getValues((Object)key);
        }
        return toReturn != null ? toReturn : Collections.emptyList();
    }

    @Override
    public List<DaoToSql> getBinaryStores() {
        return this.binaryStores != null ? this.binaryStores : Collections.emptyList();
    }

    @Override
    public void clear() {
        this.txId = TransactionId.SENTINEL;
        this.dataItemInserts = null;
        this.txNotCurrentsJoin = null;
        this.binaryStores = null;
    }

    @Override
    public void accept(TransactionReadable tx, OrcsChangeSet changeSet) throws OseeCoreException {
        this.txId = tx;
        this.binaryStores = new ArrayList<DaoToSql>();
        this.dataItemInserts = new HashCollection();
        this.txNotCurrentsJoin = new HashMap<TransactionWriter.SqlOrderEnum, IdJoinQuery>();
        this.addRow(TransactionWriter.SqlOrderEnum.TXS_DETAIL, this.txId, tx.getComment(), tx.getDate(), tx.getAuthor(), tx.getBranch(), tx.getTxType().getId(), OseeCodeVersion.getVersionId());
        changeSet.accept((OrcsVisitor)this);
    }

    public void visit(ArtifactData data) throws OseeCoreException {
        boolean isOtherChange = !data.getVersion().isInStorage() || data.hasTypeUuidChange() || data.hasModTypeChange() || data.isExistingVersionUsed();
        boolean isApplicOnly = data.getDirtyState().isApplicOnly();
        if (!this.isNewAndDeleted((OrcsData)data) && (isOtherChange || isApplicOnly)) {
            boolean reuseGamma = this.reuseGamma((OrcsData)data);
            this.updateTxValues((OrcsData)data);
            if (!isApplicOnly && !reuseGamma) {
                this.updateGamma((OrcsData)data);
                this.addRow(TransactionWriter.SqlOrderEnum.ARTIFACTS, data.getLocalId(), data.getTypeUuid(), data.getVersion().getGammaId(), data.getGuid());
            }
            this.addTxs(TransactionWriter.SqlOrderEnum.ARTIFACTS, (OrcsData)data);
        }
    }

    public void visit(AttributeData data) throws OseeCoreException {
        if (!this.isNewAndDeleted((OrcsData)data)) {
            boolean createNewGamma = !this.reuseGamma((OrcsData)data);
            this.updateTxValues((OrcsData)data);
            if (createNewGamma && !data.getDirtyState().isApplicOnly()) {
                this.updateGamma((OrcsData)data);
                DataProxy dataProxy = data.getDataProxy();
                DaoToSql daoToSql = new DaoToSql(data.getVersion().getGammaId(), dataProxy, createNewGamma);
                this.addBinaryStore(daoToSql);
                if (RelationalConstants.DEFAULT_ITEM_ID == data.getLocalId()) {
                    int localId = this.idManager.getNextAttributeId();
                    data.setLocalId(Integer.valueOf(localId));
                }
                this.addRow(TransactionWriter.SqlOrderEnum.ATTRIBUTES, data.getLocalId(), data.getTypeUuid(), data.getVersion().getGammaId(), data.getArtifactId(), daoToSql.getValue(), daoToSql.getUri());
            }
            this.addTxs(TransactionWriter.SqlOrderEnum.ATTRIBUTES, (OrcsData)data);
        }
    }

    public void visit(TupleData data) {
        this.updateTxValues((OrcsData)data);
        if (data.getElement3() == null) {
            this.addRow(TransactionWriter.SqlOrderEnum.TUPLES2, data.getTupleType(), data.getElement1(), data.getElement2(), data.getVersion().getGammaId());
            this.addTxs(TransactionWriter.SqlOrderEnum.TUPLES2, (OrcsData)data);
        } else if (data.getElement4() == null) {
            this.addRow(TransactionWriter.SqlOrderEnum.TUPLES3, data.getTupleType(), data.getElement1(), data.getElement2(), data.getElement3(), data.getVersion().getGammaId());
            this.addTxs(TransactionWriter.SqlOrderEnum.TUPLES3, (OrcsData)data);
        } else {
            this.addRow(TransactionWriter.SqlOrderEnum.TUPLES4, data.getTupleType(), data.getElement1(), data.getElement2(), data.getElement3(), data.getElement4(), data.getVersion().getGammaId());
            this.addTxs(TransactionWriter.SqlOrderEnum.TUPLES4, (OrcsData)data);
        }
    }

    @Override
    public void updateAfterBinaryStorePersist() throws OseeCoreException {
        List<Object[]> insertData = this.getInsertData(TransactionWriter.SqlOrderEnum.ATTRIBUTES);
        int index = 0;
        while (index < this.binaryStores.size() && index < insertData.size()) {
            DaoToSql dao = this.binaryStores.get(index);
            Object[] rowData = insertData.get(index);
            int end = rowData.length;
            rowData[end - 2] = dao.getValue();
            rowData[end - 1] = dao.getUri();
            ++index;
        }
    }

    public void visit(RelationData data) throws OseeCoreException {
        if (!this.isNewAndDeleted((OrcsData)data)) {
            boolean reuseGamma = this.reuseGamma((OrcsData)data);
            this.updateTxValues((OrcsData)data);
            if (!reuseGamma && !data.getDirtyState().isApplicOnly()) {
                this.updateGamma((OrcsData)data);
                if (RelationalConstants.DEFAULT_ITEM_ID == data.getLocalId()) {
                    int localId = this.idManager.getNextRelationId();
                    data.setLocalId(Integer.valueOf(localId));
                }
                this.addRow(TransactionWriter.SqlOrderEnum.RELATIONS, data.getLocalId(), data.getTypeUuid(), data.getVersion().getGammaId(), data.getArtIdA(), data.getArtIdB(), data.getRationale());
            }
            this.addTxs(TransactionWriter.SqlOrderEnum.RELATIONS, (OrcsData)data);
        }
    }

    private void addTxs(TransactionWriter.SqlOrderEnum key, OrcsData orcsData) {
        VersionData data = orcsData.getVersion();
        ModificationType modType = orcsData.getModType();
        this.addRow(TransactionWriter.SqlOrderEnum.TXS, data.getTransactionId(), data.getGammaId(), modType.getValue(), TxChange.getCurrent((ModificationType)modType).getValue(), data.getBranch(), orcsData.getApplicabilityId());
        if (key.hasTxNotCurrentQuery()) {
            IdJoinQuery join = this.txNotCurrentsJoin.get((Object)key);
            if (join == null) {
                join = this.createJoin();
                this.txNotCurrentsJoin.put(key, join);
            }
            join.add(orcsData.getLocalId());
        }
    }

    private boolean isNewAndDeleted(OrcsData data) {
        return !data.getVersion().isInStorage() && data.getModType().isDeleted();
    }

    private void updateTxValues(OrcsData orcsData) {
        orcsData.setModType(this.computeModType(orcsData.getModType()));
        orcsData.getVersion().setTransactionId(this.txId);
    }

    private void updateGamma(OrcsData data) throws OseeCoreException {
        VersionData version = data.getVersion();
        long newGamma = this.idManager.getNextGammaId();
        version.setGammaId(newGamma);
    }

    private ModificationType computeModType(ModificationType original) {
        ModificationType toReturn = original;
        if (ModificationType.REPLACED_WITH_VERSION == toReturn) {
            toReturn = ModificationType.MODIFIED;
        }
        return toReturn;
    }

    protected IdJoinQuery createJoin() {
        return this.sqlJoinFactory.createIdJoinQuery();
    }

    protected boolean reuseGamma(OrcsData data) {
        return data.getModType().isExistingVersionUsed() || data.isExistingVersionUsed();
    }

    private void addRow(TransactionWriter.SqlOrderEnum sqlKey, Object ... data) {
        this.dataItemInserts.put((Object)sqlKey, (Object)data);
    }

    private void addBinaryStore(DaoToSql binaryTx) {
        this.binaryStores.add(binaryTx);
    }
}

