/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.transaction;

import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.core.ds.DataProxy;

public class DaoToSql {
    private final long gammaId;
    private final DataProxy proxy;
    private final boolean isNewGammaId;

    public DaoToSql(long gammaId, DataProxy proxy, boolean isNewGammaId) {
        this.gammaId = gammaId;
        this.proxy = proxy;
        this.isNewGammaId = isNewGammaId;
    }

    public boolean hasNewGammaId() {
        return this.isNewGammaId;
    }

    public long getGammaId() {
        return this.gammaId;
    }

    private DataProxy getProxy() {
        return this.proxy;
    }

    public String getUri() throws OseeCoreException {
        String uri = this.getItemAt(1, this.getProxy().getData());
        return uri != null ? uri : "";
    }

    public String getValue() throws OseeCoreException {
        String value = this.getItemAt(0, this.getProxy().getData());
        return value != null ? value : "";
    }

    public void persist() throws OseeCoreException {
        if (this.isNewGammaId) {
            this.proxy.persist(this.gammaId);
        }
    }

    public void rollBack() throws OseeCoreException {
        if (this.isNewGammaId) {
            this.getProxy().purge();
        }
    }

    private String getItemAt(int index, Object ... data) {
        Object obj;
        String toReturn = null;
        if (data != null && data.length > index && (obj = data[index]) != null) {
            toReturn = obj.toString();
        }
        return toReturn;
    }

    public String toString() {
        return "DAOToSQL [gammaId=" + this.gammaId + ", isNewGammaId=" + this.isNewGammaId + ", proxy=" + this.proxy + "]";
    }
}

