/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql.join;

import org.eclipse.osee.jdbc.SQL3DataType;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.DatabaseJoinAccessor;
import org.eclipse.osee.orcs.db.internal.sql.join.IJoinAccessor;

public final class TransactionJoinQuery
extends AbstractJoinQuery {
    protected TransactionJoinQuery(IJoinAccessor joinAccessor, Long expiresIn, int queryId) {
        super(joinAccessor, DatabaseJoinAccessor.JoinItem.TRANSACTION, expiresIn, queryId);
    }

    public void add(Long gammaId, Integer transactionId) {
        this.add(gammaId, transactionId, null);
    }

    public void add(Long gammaId, Integer transactionId, Long branchUuid) {
        this.entries.add(new TempTransactionEntry(gammaId, transactionId, branchUuid));
    }

    private final class TempTransactionEntry
    implements AbstractJoinQuery.IJoinRow {
        private final Long gammaId;
        private final Integer transactionId;
        private final Long branchUuid;

        private TempTransactionEntry(Long gammaId, Integer transactionId, Long branchUuid) {
            this.gammaId = gammaId;
            this.transactionId = transactionId;
            this.branchUuid = branchUuid;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{TransactionJoinQuery.this.getQueryId(), this.gammaId, this.transactionId, this.branchUuid != null ? this.branchUuid : SQL3DataType.BIGINT};
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.branchUuid == null ? 0 : this.branchUuid.hashCode());
            result = 31 * result + (this.gammaId == null ? 0 : this.gammaId.hashCode());
            result = 31 * result + (this.transactionId == null ? 0 : this.transactionId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TempTransactionEntry other = (TempTransactionEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.branchUuid == null ? other.branchUuid != null : !this.branchUuid.equals(other.branchUuid)) {
                return false;
            }
            if (this.gammaId == null ? other.gammaId != null : !this.gammaId.equals(other.gammaId)) {
                return false;
            }
            return !(this.transactionId == null ? other.transactionId != null : !this.transactionId.equals(other.transactionId));
        }

        @Override
        public String toString() {
            return String.format("gamma_id=%s, tx_id=%s, branch_id=%s", this.gammaId, this.transactionId, this.branchUuid);
        }

        private TransactionJoinQuery getOuterType() {
            return TransactionJoinQuery.this;
        }
    }
}

