/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql.join;

import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.executor.admin.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.db.internal.sql.join.CharJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.DatabaseJoinAccessor;
import org.eclipse.osee.orcs.db.internal.sql.join.ExportImportJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IJoinAccessor;
import org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.JoinCleanerCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.TagQueueJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.TransactionJoinQuery;

public class SqlJoinFactory {
    public static final String JOIN_CLEANER__EXECUTOR_ID = "join.cleaner.executor.id";
    private static final Long DEFAULT_JOIN_EXPIRATION_SECONDS = 10800L;
    private static final long DEFAULT_JOIN_CLEANER__PERIOD_MINUTES = 60L;
    private static final String EXPIRATION_SECS__ARTIFACT_JOIN_QUERY = "artifact.join.expiration.secs";
    private static final String EXPIRATION_SECS__CHAR_JOIN_QUERY = "char.join.expiration.secs";
    private static final String EXPIRATION_SECS__EXPORT_IMPORT_JOIN_QUERY = "export.import.join.expiration.secs";
    private static final String EXPIRATION_SECS__ID_JOIN_QUERY = "id.join.expiration.secs";
    private static final String EXPIRATION_SECS__TAG_QUEUE_JOIN_QUERY = "tag.queue.join.expiration.secs";
    private static final String EXPIRATION_SECS__TX_JOIN_QUERY = "tx.join.expiration.secs";
    private Log logger;
    private JdbcService jdbcService;
    private SystemPreferences preferences;
    private ExecutorAdmin executorAdmin;
    private Random random;
    private IJoinAccessor joinAccessor;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setSystemPreferences(SystemPreferences preferences) {
        this.preferences = preferences;
    }

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void start() throws Exception {
        this.random = new Random();
        JdbcClient jdbcClient = this.jdbcService.getClient();
        this.joinAccessor = new DatabaseJoinAccessor(jdbcClient);
        JoinCleanerCallable callable = new JoinCleanerCallable(this.logger, jdbcClient);
        this.executorAdmin.scheduleAtFixedRate(JOIN_CLEANER__EXECUTOR_ID, (Callable)((Object)callable), 60L, 60L, TimeUnit.MINUTES);
    }

    public void stop() throws Exception {
        if (this.executorAdmin != null) {
            this.executorAdmin.shutdown(JOIN_CLEANER__EXECUTOR_ID);
        }
        this.random = null;
    }

    private int getNewQueryId() {
        return this.random.nextInt();
    }

    private IJoinAccessor getAccessor() {
        return this.joinAccessor;
    }

    public TransactionJoinQuery createTransactionJoinQuery() {
        return this.createTransactionJoinQuery(null);
    }

    public TransactionJoinQuery createTransactionJoinQuery(Long expiresIn) {
        Long actualExpiration = this.getExpiresIn(expiresIn, EXPIRATION_SECS__TX_JOIN_QUERY);
        return new TransactionJoinQuery(this.getAccessor(), actualExpiration, this.getNewQueryId());
    }

    public IdJoinQuery createIdJoinQuery() {
        return this.createIdJoinQuery(null);
    }

    public IdJoinQuery createIdJoinQuery(Long expiresIn) {
        Long actualExpiration = this.getExpiresIn(expiresIn, EXPIRATION_SECS__ID_JOIN_QUERY);
        return new IdJoinQuery(this.getAccessor(), actualExpiration, this.getNewQueryId());
    }

    public Id4JoinQuery createId4JoinQuery() {
        return this.createId4JoinQuery(null);
    }

    public Id4JoinQuery createId4JoinQuery(Long expiresIn) {
        Long actualExpiration = this.getExpiresIn(expiresIn, EXPIRATION_SECS__ID_JOIN_QUERY);
        return new Id4JoinQuery(this.getAccessor(), actualExpiration, this.getNewQueryId(), this.getMaxArtifactJoinSize());
    }

    public TagQueueJoinQuery createTagQueueJoinQuery() {
        return this.createTagQueueJoinQuery(null);
    }

    public TagQueueJoinQuery createTagQueueJoinQuery(Long expiresIn) {
        Long actualExpiration = this.getExpiresIn(expiresIn, EXPIRATION_SECS__TAG_QUEUE_JOIN_QUERY);
        return new TagQueueJoinQuery(this.getAccessor(), actualExpiration, this.getNewQueryId());
    }

    public ExportImportJoinQuery createExportImportJoinQuery() {
        return this.createExportImportJoinQuery(null);
    }

    public ExportImportJoinQuery createExportImportJoinQuery(Long expiresIn) {
        Long actualExpiration = this.getExpiresIn(expiresIn, EXPIRATION_SECS__EXPORT_IMPORT_JOIN_QUERY);
        return new ExportImportJoinQuery(this.getAccessor(), actualExpiration, this.getNewQueryId());
    }

    public CharJoinQuery createCharJoinQuery() {
        return this.createCharJoinQuery(null);
    }

    public CharJoinQuery createCharJoinQuery(Long expiresIn) {
        Long actualExpiration = this.getExpiresIn(expiresIn, EXPIRATION_SECS__CHAR_JOIN_QUERY);
        return new CharJoinQuery(this.getAccessor(), actualExpiration, this.getNewQueryId());
    }

    private Long getExpiresIn(Long actual, String defaultKey) {
        Long toReturn = DEFAULT_JOIN_EXPIRATION_SECONDS;
        if (actual != null) {
            toReturn = actual;
        } else {
            String expiration = this.preferences.getCachedValue(defaultKey);
            if (Strings.isNumeric((String)expiration)) {
                toReturn = Long.parseLong(expiration);
            }
        }
        return toReturn;
    }

    private int getMaxArtifactJoinSize() {
        int toReturn = Integer.MAX_VALUE;
        String maxSize = this.preferences.getCachedValue("artifact.join.max.size");
        if (Strings.isNumeric((String)maxSize)) {
            toReturn = Integer.parseInt(maxSize);
        }
        return toReturn;
    }
}

