/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql.join;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.osee.executor.admin.CancellableCallable;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;

public class JoinCleanerCallable
extends CancellableCallable<Void> {
    private static final String DELETE_JOIN_CLEANUP = "DELETE FROM osee_join_cleanup WHERE query_id = ?";
    private static final String SELECT_FROM_JOIN_CLEANUP = "SELECT * from osee_join_cleanup";
    private final Log logger;
    private final JdbcClient jdbcClient;

    public JoinCleanerCallable(Log logger, JdbcClient jdbcClient) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
    }

    private boolean isExpired(Long issuedAt, Long lifetime) {
        return lifetime != -1L && issuedAt + lifetime < System.currentTimeMillis() / 1000L;
    }

    public Void call() throws Exception {
        try {
            ListMultimap expiredItems = JoinCleanerCallable.newListMultimap();
            Consumer<JdbcStatement> consumer = stmt -> {
                Long expiresIn;
                Long issuedAt = stmt.getLong("issued_at");
                if (this.isExpired(issuedAt, expiresIn = Long.valueOf(stmt.getLong("expires_in")))) {
                    String tableName = stmt.getString("table_name");
                    Integer queryId = stmt.getInt("query_id");
                    expiredItems.put((Object)tableName, (Object)new Integer[]{queryId});
                }
            };
            this.jdbcClient.runQuery(consumer, SELECT_FROM_JOIN_CLEANUP, new Object[0]);
            if (!expiredItems.isEmpty()) {
                for (Map.Entry entry : expiredItems.asMap().entrySet()) {
                    String query = String.format("DELETE FROM %s WHERE query_id = ?", entry.getKey());
                    List ids = (List)entry.getValue();
                    this.jdbcClient.runBatchUpdate(query, (Iterable)ids);
                    this.jdbcClient.runBatchUpdate(DELETE_JOIN_CLEANUP, (Iterable)ids);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error cleaning join", new Object[0]);
            throw ex;
        }
        return null;
    }

    private static <K, V> ListMultimap<K, V> newListMultimap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        return Multimaps.newListMultimap((Map)map, (Supplier)new Supplier<List<V>>(){

            public List<V> get() {
                return Lists.newArrayList();
            }
        });
    }
}

