/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql.join;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.exception.OseeDataStoreException;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.DatabaseJoinAccessor;
import org.eclipse.osee.orcs.db.internal.sql.join.IJoinAccessor;

public class Id4JoinQuery
extends AbstractJoinQuery {
    private final int maxJoinSize;

    public Id4JoinQuery(IJoinAccessor joinAccessor, Long expiresIn, int queryId, int maxJoinSize) {
        super(joinAccessor, DatabaseJoinAccessor.JoinItem.ID4, expiresIn, queryId);
        this.maxJoinSize = maxJoinSize;
    }

    public void add(Id id_1, Id id_2, Id id_3, Id id_4) {
        this.entries.add(new Entry(id_1, id_2, id_3, id_4));
        if (this.entries.size() > this.maxJoinSize) {
            throw new OseeDataStoreException("Exceeded max artifact join size of [%d]", new Object[]{this.maxJoinSize});
        }
    }

    public void add(Id id_1, Id id_2, Id id_3) {
        this.add(id_1, id_2, id_3, (Id)ArtifactId.SENTINEL);
    }

    public void add(Id id_1, Id id_2) {
        this.add(id_1, id_2, (Id)TransactionId.SENTINEL, (Id)ArtifactId.SENTINEL);
    }

    private final class Entry
    implements AbstractJoinQuery.IJoinRow {
        private final Id id_1;
        private final Id id_2;
        private final Id id_3;
        private final Id id_4;

        private Entry(Id id_1, Id id_2, Id id_3, Id id_4) {
            this.id_1 = id_1;
            this.id_2 = id_2;
            this.id_3 = id_3;
            this.id_4 = id_4;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{Id4JoinQuery.this.getQueryId(), this.id_1, this.id_2, this.id_3, this.id_4};
        }

        @Override
        public String toString() {
            return String.format("id_1=%s, id_2=%s, id_3=%s, id_4=%s", this.id_1, this.id_2, this.id_3, this.id_4);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.id_1 == null ? other.id_1 != null : !this.id_1.equals(other.id_1)) {
                return false;
            }
            if (this.id_2 == null ? other.id_2 != null : !this.id_2.equals(other.id_2)) {
                return false;
            }
            if (this.id_3 == null ? other.id_3 != null : !this.id_3.equals(other.id_3)) {
                return false;
            }
            return this.id_4.equals(other.id_4);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.id_1 == null ? 0 : this.id_1.hashCode());
            result = 31 * result + (this.id_2 == null ? 0 : this.id_2.hashCode());
            result = 31 * result + (this.id_3 == null ? 0 : this.id_3.hashCode());
            result = 31 * result + (this.id_4 == null ? 0 : this.id_4.hashCode());
            return result;
        }

        private Id4JoinQuery getOuterType() {
            return Id4JoinQuery.this;
        }
    }
}

